/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Ore;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.util.GuavaJavaUtils;

@Mixin(value={WorldGenMinable.class})
public abstract class MixinWorldGenMinable
extends WorldGenerator
implements Ore {
    @Shadow
    private IBlockState field_175920_a;
    @Shadow
    private int field_76541_b;
    @Shadow
    private com.google.common.base.Predicate<IBlockState> field_175919_c;
    private VariableAmount size;
    private VariableAmount count;
    private VariableAmount height;

    @Inject(method="<init>(Lnet/minecraft/block/state/IBlockState;ILcom/google/common/base/Predicate;)V", at={@At(value="RETURN")})
    public void onConstructed(IBlockState ore, int count, com.google.common.base.Predicate<IBlockState> condition, CallbackInfo ci) {
        this.size = VariableAmount.fixed(count);
        this.count = VariableAmount.fixed(16.0);
        this.height = VariableAmount.baseWithRandomAddition(0.0, 64.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.ORE;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        int n = this.count.getFlooredAmount(random);
        BlockPos position = new BlockPos(min.getX() - 8, min.getY(), min.getZ() - 8);
        for (int i = 0; i < n; ++i) {
            BlockPos pos = position.func_177982_a(random.nextInt(size.getX()), this.height.getFlooredAmount(random), random.nextInt(size.getX()));
            this.field_76541_b = this.size.getFlooredAmount(random);
            this.func_180709_b(world, random, pos);
        }
    }

    @Override
    public BlockState getOreBlock() {
        return (BlockState)this.field_175920_a;
    }

    @Override
    public void setOreBlock(BlockState block) {
        this.field_175920_a = (IBlockState)block;
    }

    @Override
    public VariableAmount getDepositSize() {
        return this.size;
    }

    @Override
    public void setDepositSize(VariableAmount size) {
        this.size = size;
    }

    @Override
    public VariableAmount getDepositsPerChunk() {
        return this.count;
    }

    @Override
    public void setDepositsPerChunk(VariableAmount count) {
        this.count = count;
    }

    @Override
    public VariableAmount getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(VariableAmount height) {
        this.height = height;
    }

    @Override
    public Predicate<BlockState> getPlacementCondition() {
        return GuavaJavaUtils.asJavaPredicate(this.field_175919_c);
    }

    @Override
    public void setPlacementCondition(Predicate<BlockState> condition) {
        this.field_175919_c = GuavaJavaUtils.asGuavaPredicate(condition);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"Ore").add("OreBlock", (Object)this.field_175920_a).add("Size", (Object)this.size).add("PerChunk", (Object)this.count).add("Height", (Object)this.height).toString();
    }
}

