/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Pumpkin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenPumpkin.class})
public class MixinWorldGenPumpkin
implements Pumpkin {
    private VariableAmount count;
    private double chance;

    @Inject(method="<init>()V", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.count = VariableAmount.fixed(10.0);
        this.chance = 0.1;
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.PUMPKIN;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        if (random.nextDouble() < this.chance) {
            int x = min.getX() + random.nextInt(size.getX());
            int z = min.getZ() + random.nextInt(size.getZ());
            int height = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o();
            int y = min.getY() + height < 1 ? 0 : random.nextInt(height * 2);
            this.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos p_180709_3_) {
        int n = this.count.getFlooredAmount(rand);
        for (int i = 0; i < n; ++i) {
            BlockPos blockpos1 = p_180709_3_.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d(blockpos1) || worldIn.func_180495_p(blockpos1.func_177977_b()).func_177230_c() != Blocks.field_150349_c || !Blocks.field_150423_aK.func_176196_c(worldIn, blockpos1)) continue;
            worldIn.func_180501_a(blockpos1, Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_185512_D, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179518_a(rand)), 2);
        }
        return true;
    }

    @Override
    public VariableAmount getPumpkinsPerChunk() {
        return this.count;
    }

    @Override
    public void setPumpkinsPerChunk(VariableAmount count) {
        this.count = count;
    }

    @Override
    public double getPumpkinChance() {
        return this.chance;
    }

    @Override
    public void setPumpkinChance(double p) {
        this.chance = p;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"Pumpkin").add("PerChunk", (Object)this.count).add("Chance", this.chance).toString();
    }
}

