/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenReed;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Reed;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenReed.class})
public class MixinWorldGenReed
implements Reed {
    private VariableAmount count;
    private VariableAmount height;

    @Inject(method="<init>()V", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.count = VariableAmount.fixed(10.0);
        this.height = VariableAmount.baseWithRandomAddition(2.0, 2.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.REED;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos position = new BlockPos(min.getX(), min.getY(), min.getZ());
        int x = random.nextInt(size.getX());
        int z = random.nextInt(size.getZ());
        position = world.func_175672_r(position.func_177982_a(x, 0, z));
        this.func_180709_b(world, random, position);
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int n = this.count.getFlooredAmount(rand);
        for (int i = 0; i < n; ++i) {
            BlockPos blockpos2;
            BlockPos blockpos1 = position.func_177982_a(rand.nextInt(4) - rand.nextInt(4), 0, rand.nextInt(4) - rand.nextInt(4));
            if (!worldIn.func_175623_d(blockpos1) || worldIn.func_180495_p((blockpos2 = blockpos1.func_177977_b()).func_177976_e()).func_185904_a() != Material.field_151586_h && worldIn.func_180495_p(blockpos2.func_177974_f()).func_185904_a() != Material.field_151586_h && worldIn.func_180495_p(blockpos2.func_177978_c()).func_185904_a() != Material.field_151586_h && worldIn.func_180495_p(blockpos2.func_177968_d()).func_185904_a() != Material.field_151586_h) continue;
            int height = this.height.getFlooredAmount(rand);
            for (int y = 0; y < height; ++y) {
                if (!Blocks.field_150436_aH.func_176354_d(worldIn, blockpos1)) continue;
                worldIn.func_180501_a(blockpos1.func_177981_b(y), Blocks.field_150436_aH.func_176223_P(), 2);
            }
        }
        return true;
    }

    @Override
    public VariableAmount getReedsPerChunk() {
        return this.count;
    }

    @Override
    public void setReedsPerChunk(VariableAmount count) {
        this.count = count;
    }

    @Override
    public VariableAmount getReedHeight() {
        return this.height;
    }

    @Override
    public void setReedHeight(VariableAmount height) {
        this.height = height;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"Reed").add("PerChunk", (Object)this.count).add("Height", (Object)this.height).toString();
    }
}

