/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.WaterLily;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenWaterlily.class})
public abstract class MixinWorldGenWaterLily
extends WorldGenerator
implements WaterLily {
    private VariableAmount count;

    @Inject(method="<init>()V", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.count = VariableAmount.fixed(4.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.WATER_LILY;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        int n = this.count.getFlooredAmount(random);
        BlockPos position = new BlockPos(min.getX(), min.getY(), min.getZ());
        if ((n /= 10) < 0) {
            ++n;
        }
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            BlockPos pos = position.func_177982_a(x, 0, z);
            pos = world.func_175672_r(pos);
            this.func_180709_b(world, random, pos);
        }
    }

    @Override
    public VariableAmount getWaterLilyPerChunk() {
        return this.count;
    }

    @Override
    public void setWaterLilyPerChunk(VariableAmount count) {
        this.count = count;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"WaterLily").add("PerChunk", (Object)this.count).toString();
    }
}

