/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollisions;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.CollisionModCategory;
import org.spongepowered.common.config.category.EntityCollisionCategory;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.IModData_Collisions;

@Mixin(value={Block.class})
public abstract class MixinBlock_Collisions
implements IModData_Collisions {
    private BlockType collisionBlockType = (BlockType)((Object)this);
    private int maxCollisions = 8;
    private String modId;
    private String modBlockName;
    private boolean refreshCache = true;

    @Override
    public int getMaxCollisions() {
        return this.maxCollisions;
    }

    @Override
    public void setMaxCollisions(int max) {
        this.maxCollisions = max;
    }

    @Override
    public void setModDataName(String name) {
        this.modBlockName = name;
    }

    @Override
    public String getModDataId() {
        return this.modId;
    }

    @Override
    public void setModDataId(String id) {
        this.modId = id;
    }

    @Override
    public void requiresCollisionsCacheRefresh(boolean flag) {
        this.refreshCache = flag;
    }

    @Override
    public boolean requiresCollisionsCacheRefresh() {
        return this.refreshCache;
    }

    @Override
    public void initializeCollisionState(World worldIn) {
        SpongeConfig<?> activeConfig = ((IMixinWorldServer)worldIn).getActiveConfig();
        EntityCollisionCategory collisionCat = ((ConfigBase)activeConfig.getConfig()).getEntityCollisionCategory();
        IModData_Collisions spongeBlock = (IModData_Collisions)((Object)this.collisionBlockType);
        spongeBlock.setMaxCollisions(collisionCat.getMaxEntitiesWithinAABB());
        String[] ids = this.collisionBlockType.getId().split(":");
        String modId = ids[0];
        String name = ids[1];
        CollisionModCategory collisionMod = collisionCat.getModList().get(modId);
        if (collisionMod == null && ((ConfigBase)activeConfig.getConfig()).getEntityCollisionCategory().autoPopulateData()) {
            collisionMod = new CollisionModCategory(modId);
            collisionCat.getModList().put(modId, collisionMod);
            collisionMod.getBlockList().put(name, spongeBlock.getMaxCollisions());
            if (((ConfigBase)activeConfig.getConfig()).getEntityCollisionCategory().autoPopulateData()) {
                activeConfig.save();
            }
            return;
        }
        if (collisionMod != null) {
            Integer blockMaxCollision;
            if (!collisionMod.isEnabled()) {
                spongeBlock.setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = collisionMod.getDefaultMaxCollisions().get("blocks");
            if (modCollisionMax != null) {
                spongeBlock.setMaxCollisions(modCollisionMax);
            }
            if ((blockMaxCollision = collisionMod.getBlockList().get(name)) == null && ((ConfigBase)activeConfig.getConfig()).getEntityCollisionCategory().autoPopulateData()) {
                collisionMod.getBlockList().put(name, spongeBlock.getMaxCollisions());
            } else if (blockMaxCollision != null) {
                spongeBlock.setMaxCollisions(blockMaxCollision);
            }
        }
        if (spongeBlock.getMaxCollisions() <= 0) {
            return;
        }
        if (((ConfigBase)activeConfig.getConfig()).getEntityCollisionCategory().autoPopulateData()) {
            activeConfig.save();
        }
    }
}

