/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracking.world;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.profile.SpongeProfileManager;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.SpongeUsernameCache;

@Mixin(value={net.minecraft.world.chunk.Chunk.class}, priority=1111)
public abstract class MixinChunk_Tracker
implements Chunk,
IMixinChunk {
    private static final int NUM_XZ_BITS = 4;
    private static final int NUM_SHORT_Y_BITS = 8;
    private static final int NUM_INT_Y_BITS = 24;
    private static final int Y_SHIFT = 4;
    private static final int Z_SHORT_SHIFT = 12;
    private static final int Z_INT_SHIFT = 28;
    private static final short XZ_MASK = 15;
    private static final short Y_SHORT_MASK = 255;
    private static final int Y_INT_MASK = 0xFFFFFF;
    private SpongeProfileManager spongeProfileManager;
    private UserStorageService userStorageService;
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    private ExtendedBlockStorage[] field_76652_q;
    @Shadow
    @Final
    private int[] field_76638_b;
    @Shadow
    @Final
    private int[] field_76634_f;
    @Shadow
    private boolean field_76643_l;
    public Map<Integer, PlayerTracker> trackedIntBlockPositions = new Int2ObjectArrayMap<PlayerTracker>();
    public Map<Short, PlayerTracker> trackedShortBlockPositions = new Short2ObjectArrayMap<PlayerTracker>();

    @Final
    @Inject(method="<init>(Lnet/minecraft/world/World;II)V", at={@At(value="RETURN")}, remap=false)
    public void onConstructedTracker(World world, int x, int z, CallbackInfo ci) {
        if (!world.field_72995_K) {
            this.spongeProfileManager = (SpongeProfileManager)Sponge.getServer().getGameProfileManager();
            this.userStorageService = SpongeImpl.getGame().getServiceManager().provide(UserStorageService.class).get();
        }
    }

    @Override
    public void addTrackedBlockPosition(Block block, BlockPos pos, User user, PlayerTracker.Type trackerType) {
        if (this.field_76637_e.field_72995_K) {
            return;
        }
        if (CauseTracker.getInstance().getCurrentState().ignoresBlockTracking()) {
            return;
        }
        if (user instanceof EntityPlayerMP && SpongeImplHooks.isFakePlayer((Entity)((EntityPlayerMP)user))) {
            return;
        }
        if (!((ConfigBase)SpongeHooks.getActiveConfig((WorldServer)this.field_76637_e).getConfig()).getBlockTracking().getBlockBlacklist().contains(((BlockType)block).getId())) {
            SpongeHooks.logBlockTrack(this.field_76637_e, block, pos, user, true);
        } else {
            SpongeHooks.logBlockTrack(this.field_76637_e, block, pos, user, false);
        }
        IMixinWorldInfo worldInfo = (IMixinWorldInfo)this.field_76637_e.func_72912_H();
        int indexForUniqueId = worldInfo.getIndexForUniqueId(user.getUniqueId());
        if (pos.func_177956_o() <= 255) {
            short blockPos = this.blockPosToShort(pos);
            PlayerTracker playerTracker = this.trackedShortBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (trackerType == PlayerTracker.Type.OWNER) {
                    playerTracker.ownerIndex = indexForUniqueId;
                    playerTracker.notifierIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.trackedShortBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, trackerType));
            }
        } else {
            int blockPos = this.blockPosToInt(pos);
            PlayerTracker playerTracker = this.trackedIntBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (trackerType == PlayerTracker.Type.OWNER) {
                    playerTracker.ownerIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.trackedIntBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, trackerType));
            }
        }
    }

    @Override
    public Map<Integer, PlayerTracker> getTrackedIntPlayerPositions() {
        return this.trackedIntBlockPositions;
    }

    @Override
    public Map<Short, PlayerTracker> getTrackedShortPlayerPositions() {
        return this.trackedShortBlockPositions;
    }

    @Override
    public Optional<User> getBlockOwner(BlockPos pos) {
        int key = this.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            UUID uuid = ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getUniqueIdForIndex(intTracker.ownerIndex).orElse(null);
            if (uuid != null) {
                UUID userUniqueId = uuid;
                EntityPlayer player = this.field_76637_e.func_152378_a(userUniqueId);
                if (player != null) {
                    return Optional.of((User)player);
                }
                if (SpongeImpl.getGlobalConfig().getConfig().getWorld().getInvalidLookupUuids().contains(userUniqueId)) {
                    this.trackedIntBlockPositions.remove(key);
                    return Optional.empty();
                }
                return this.getUserFromId(userUniqueId);
            }
        } else {
            Optional<UUID> uuid;
            short shortKey = this.blockPosToShort(pos);
            PlayerTracker shortTracker = this.trackedShortBlockPositions.get(shortKey);
            if (shortTracker != null && (uuid = ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getUniqueIdForIndex(shortTracker.ownerIndex)).isPresent()) {
                UUID userUniqueId = uuid.get();
                EntityPlayer player = this.field_76637_e.func_152378_a(userUniqueId);
                if (player != null) {
                    return Optional.of((User)player);
                }
                if (SpongeImpl.getGlobalConfig().getConfig().getWorld().getInvalidLookupUuids().contains(userUniqueId)) {
                    this.trackedShortBlockPositions.remove(shortKey);
                    return Optional.empty();
                }
                return this.getUserFromId(userUniqueId);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<User> getBlockNotifier(BlockPos pos) {
        int intKey = this.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackedIntBlockPositions.get(intKey);
        if (intTracker != null) {
            UUID uuid = ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getUniqueIdForIndex(intTracker.notifierIndex).orElse(null);
            if (uuid != null) {
                UUID userUniqueId = uuid;
                EntityPlayer player = this.field_76637_e.func_152378_a(userUniqueId);
                if (player != null) {
                    return Optional.of((User)player);
                }
                if (SpongeImpl.getGlobalConfig().getConfig().getWorld().getInvalidLookupUuids().contains(userUniqueId)) {
                    this.trackedIntBlockPositions.remove(intKey);
                    return Optional.empty();
                }
                return this.getUserFromId(userUniqueId);
            }
        } else if (this.trackedShortBlockPositions.get(this.blockPosToShort(pos)) != null) {
            short blockPos = this.blockPosToShort(pos);
            PlayerTracker tracker = this.trackedShortBlockPositions.get(blockPos);
            UUID uuid = ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getUniqueIdForIndex(tracker.notifierIndex).orElse(null);
            if (uuid != null) {
                UUID userUniqueId = uuid;
                EntityPlayer player = this.field_76637_e.func_152378_a(userUniqueId);
                if (player != null) {
                    return Optional.of((User)player);
                }
                if (SpongeImpl.getGlobalConfig().getConfig().getWorld().getInvalidLookupUuids().contains(userUniqueId)) {
                    this.trackedShortBlockPositions.remove(blockPos);
                    return Optional.empty();
                }
                return this.getUserFromId(userUniqueId);
            }
        }
        return Optional.empty();
    }

    private Optional<User> getUserFromId(UUID uuid) {
        String username = SpongeUsernameCache.getLastKnownUsername(uuid);
        if (username != null) {
            return this.userStorageService.get(GameProfile.of(uuid, username));
        }
        GameProfile profile = this.spongeProfileManager.getCache().getById(uuid).orElse(null);
        if (profile != null) {
            return this.userStorageService.get(profile);
        }
        this.spongeProfileManager.lookupUserAsync(uuid);
        return Optional.empty();
    }

    @Override
    public void setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
        if (pos.func_177956_o() <= 255) {
            short blockPos = this.blockPosToShort(pos);
            if (this.trackedShortBlockPositions.get(blockPos) != null) {
                this.trackedShortBlockPositions.get((Object)Short.valueOf((short)blockPos)).notifierIndex = uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid);
            } else {
                this.trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        } else {
            int blockPos = this.blockPosToInt(pos);
            if (this.trackedIntBlockPositions.get(blockPos) != null) {
                this.trackedIntBlockPositions.get((Object)Integer.valueOf((int)blockPos)).notifierIndex = uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid);
            } else {
                this.trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        }
    }

    @Override
    public void setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
        if (pos.func_177956_o() <= 255) {
            short blockPos = this.blockPosToShort(pos);
            if (this.trackedShortBlockPositions.get(blockPos) != null) {
                this.trackedShortBlockPositions.get((Object)Short.valueOf((short)blockPos)).ownerIndex = uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid);
            } else {
                this.trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid), PlayerTracker.Type.OWNER));
            }
        } else {
            int blockPos = this.blockPosToInt(pos);
            if (this.trackedIntBlockPositions.get(blockPos) != null) {
                this.trackedIntBlockPositions.get((Object)Integer.valueOf((int)blockPos)).ownerIndex = uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid);
            } else {
                this.trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid), PlayerTracker.Type.OWNER));
            }
        }
    }

    @Override
    public void setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
        this.trackedIntBlockPositions = trackedPositions;
    }

    @Override
    public void setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
        this.trackedShortBlockPositions = trackedPositions;
    }

    private int setNibble(int num, int data, int which, int bitsToReplace) {
        return num & ~(bitsToReplace << which * 4) | data << which * 4;
    }

    @Inject(method="onChunkLoad", at={@At(value="HEAD")})
    private void startChunkLoad(CallbackInfo callbackInfo) {
        if (CauseTracker.ENABLED && !this.field_76637_e.field_72995_K) {
            CauseTracker.getInstance().switchToPhase(GenerationPhase.State.CHUNK_LOADING, PhaseContext.start().add(NamedCause.source(this)).add(NamedCause.of("World", this.field_76637_e)).addCaptures().complete());
        }
    }

    @Inject(method="onChunkLoad", at={@At(value="RETURN")})
    private void endChunkLoad(CallbackInfo callbackInfo) {
        if (CauseTracker.ENABLED && !this.field_76637_e.field_72995_K) {
            CauseTracker.getInstance().completePhase(GenerationPhase.State.CHUNK_LOADING);
        }
    }

    private short blockPosToShort(BlockPos pos) {
        short serialized = (short)this.setNibble(0, pos.func_177958_n() & 0xF, 0, 4);
        serialized = (short)this.setNibble(serialized, pos.func_177956_o() & 0xFF, 1, 8);
        serialized = (short)this.setNibble(serialized, pos.func_177952_p() & 0xF, 3, 4);
        return serialized;
    }

    private BlockPos blockPosFromShort(short serialized) {
        int x = this.field_76635_g * 16 + (serialized & 0xF);
        int y = serialized >> 4 & 0xFF;
        int z = this.field_76647_h * 16 + (serialized >> 12 & 0xF);
        return new BlockPos(x, y, z);
    }

    private int blockPosToInt(BlockPos pos) {
        int serialized = this.setNibble(0, pos.func_177958_n() & 0xF, 0, 4);
        serialized = this.setNibble(serialized, pos.func_177956_o() & 0xFFFFFF, 1, 24);
        serialized = this.setNibble(serialized, pos.func_177952_p() & 0xF, 7, 4);
        return serialized;
    }

    private BlockPos blockPosFromInt(int serialized) {
        int x = this.field_76635_g * 16 + (serialized & 0xF);
        int y = serialized >> 4 & 0xFFFFFF;
        int z = this.field_76647_h * 16 + (serialized >> 28 & 0xF);
        return new BlockPos(x, y, z);
    }
}

