/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.message;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.api.network.Message;

public final class MessageTrackerDataResponse
implements Message {
    @Nullable
    public String owner;
    @Nullable
    public String notifier;

    public MessageTrackerDataResponse() {
    }

    public MessageTrackerDataResponse(String owner, String notifier) {
        this.owner = owner;
        this.notifier = notifier;
    }

    @Override
    public void readFrom(ChannelBuf buf) {
        ByteBuf buffer = (ByteBuf)buf;
        int ownerLength = buffer.readInt();
        this.owner = new String(buffer.readBytes(ownerLength).array());
        int notifierLength = buffer.readInt();
        this.notifier = new String(buffer.readBytes(notifierLength).array());
    }

    @Override
    public void writeTo(ChannelBuf buf) {
        ByteBuf buffer = (ByteBuf)buf;
        buffer.writeInt(this.owner.length());
        buffer.writeBytes(this.owner.getBytes());
        buffer.writeInt(this.notifier.length());
        buffer.writeBytes(this.notifier.getBytes());
    }

    public String toString() {
        return String.format("SpongeMessageTrackerData - owner:%s, notifier:%s", this.owner, this.notifier);
    }
}

