/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.status;

import com.google.common.base.Objects;
import java.net.InetSocketAddress;
import java.util.Optional;
import net.minecraft.network.NetworkManager;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.network.status.StatusClient;
import org.spongepowered.common.interfaces.IMixinNetworkManager;

public class SpongeStatusClient
implements StatusClient {
    private final IMixinNetworkManager connection;

    public SpongeStatusClient(NetworkManager networkManager) {
        this.connection = (IMixinNetworkManager)networkManager;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.connection.getAddress();
    }

    @Override
    public MinecraftVersion getVersion() {
        return this.connection.getVersion();
    }

    @Override
    public Optional<InetSocketAddress> getVirtualHost() {
        return Optional.ofNullable(this.connection.getVirtualHost());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpongeStatusClient)) {
            return false;
        }
        SpongeStatusClient that = (SpongeStatusClient)o;
        return Objects.equal((Object)this.connection, (Object)that.connection);
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.connection).toString();
    }
}

