/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.inject.Singleton;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.GameRegistry;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.value.ValueFactory;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.ai.task.AITaskType;
import org.spongepowered.api.entity.ai.task.AbstractAITask;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.merchant.VillagerRegistry;
import org.spongepowered.api.item.recipe.RecipeRegistry;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.ExtraClassCatalogRegistryModule;
import org.spongepowered.api.registry.RegistrationPhase;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.util.PluginProvidedRegistryModule;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.statistic.BlockStatistic;
import org.spongepowered.api.statistic.EntityStatistic;
import org.spongepowered.api.statistic.ItemStatistic;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.api.statistic.StatisticGroup;
import org.spongepowered.api.statistic.TeamStatistic;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.serializer.TextSerializerFactory;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.world.extent.ExtentBufferFactory;
import org.spongepowered.api.world.gamerule.DefaultGameRules;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.CatalogTypeTypeSerializer;
import org.spongepowered.common.data.DataRegistrar;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.property.SpongePropertyRegistry;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.network.status.SpongeFavicon;
import org.spongepowered.common.registry.CommonModuleRegistry;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.SpongeVillagerRegistry;
import org.spongepowered.common.registry.type.block.RotationRegistryModule;
import org.spongepowered.common.registry.type.entity.AITaskTypeModule;
import org.spongepowered.common.registry.type.scoreboard.DisplaySlotRegistryModule;
import org.spongepowered.common.registry.util.RegistryModuleLoader;
import org.spongepowered.common.text.selector.SpongeSelectorFactory;
import org.spongepowered.common.text.serializer.SpongeTextSerializerFactory;
import org.spongepowered.common.text.translation.SpongeTranslation;
import org.spongepowered.common.util.LanguageUtil;
import org.spongepowered.common.util.graph.DirectedGraph;
import org.spongepowered.common.util.graph.TopologicalOrder;
import org.spongepowered.common.world.extent.SpongeExtentBufferFactory;

@Singleton
public class SpongeGameRegistry
implements GameRegistry {
    private RegistrationPhase phase = RegistrationPhase.PRE_REGISTRY;
    protected final Map<Class<? extends CatalogType>, CatalogRegistryModule<?>> catalogRegistryMap = new IdentityHashMap();
    private List<Class<? extends RegistryModule>> orderedModules = new ArrayList<Class<? extends RegistryModule>>();
    final Map<Class<? extends RegistryModule>, RegistryModule> classMap = new IdentityHashMap<Class<? extends RegistryModule>, RegistryModule>();
    private final Map<Class<?>, Supplier<?>> builderSupplierMap = new IdentityHashMap();
    private final Set<RegistryModule> registryModules = new HashSet<RegistryModule>();

    public final RegistrationPhase getPhase() {
        return this.phase;
    }

    public void preRegistryInit() {
        CommonModuleRegistry.getInstance().registerDefaultModules();
        DirectedGraph<Class<? extends RegistryModule>> graph = new DirectedGraph<Class<? extends RegistryModule>>();
        for (RegistryModule registryModule : this.registryModules) {
            this.classMap.put(registryModule.getClass(), registryModule);
            this.addToGraph(registryModule, graph);
        }
        for (CatalogRegistryModule catalogRegistryModule : this.catalogRegistryMap.values()) {
            this.classMap.put(catalogRegistryModule.getClass(), catalogRegistryModule);
            this.addToGraph(catalogRegistryModule, graph);
        }
        this.orderedModules.addAll(TopologicalOrder.createOrderedLoad(graph));
        this.registerModulePhase();
        SpongeVillagerRegistry.registerVanillaTrades();
        DataRegistrar.setupSerialization(SpongeImpl.getGame());
    }

    @Override
    public <T extends CatalogType> SpongeGameRegistry registerModule(Class<T> catalogClass, CatalogRegistryModule<T> registryModule) {
        Preconditions.checkArgument((!this.catalogRegistryMap.containsKey(catalogClass) ? 1 : 0) != 0, (Object)"Already registered a registry module!");
        this.catalogRegistryMap.put(catalogClass, registryModule);
        if (this.phase != RegistrationPhase.PRE_REGISTRY) {
            if (catalogClass.getName().contains("org.spongepowered.api") && catalogClass.getAnnotation(PluginProvidedRegistryModule.class) == null) {
                throw new UnsupportedOperationException("Cannot register a module for an API defined class! That's the implementation's job!");
            }
            this.syncModules();
        }
        return this;
    }

    @Override
    public SpongeGameRegistry registerModule(RegistryModule module) {
        Preconditions.checkArgument((!this.registryModules.contains(module) ? 1 : 0) != 0);
        this.registryModules.add((RegistryModule)Preconditions.checkNotNull((Object)module));
        if (this.phase != RegistrationPhase.PRE_REGISTRY) {
            this.syncModules();
        }
        return this;
    }

    private void syncModules() {
        DirectedGraph<Class<? extends RegistryModule>> graph = new DirectedGraph<Class<? extends RegistryModule>>();
        for (RegistryModule registryModule : this.registryModules) {
            if (!this.classMap.containsKey(registryModule.getClass())) {
                this.classMap.put(registryModule.getClass(), registryModule);
            }
            this.addToGraph(registryModule, graph);
        }
        for (CatalogRegistryModule catalogRegistryModule : this.catalogRegistryMap.values()) {
            if (!this.classMap.containsKey(catalogRegistryModule.getClass())) {
                this.classMap.put(catalogRegistryModule.getClass(), catalogRegistryModule);
            }
            this.addToGraph(catalogRegistryModule, graph);
        }
        this.orderedModules.clear();
        this.orderedModules.addAll(TopologicalOrder.createOrderedLoad(graph));
    }

    @Override
    public <T> SpongeGameRegistry registerBuilderSupplier(Class<T> builderClass, Supplier<? extends T> supplier) {
        Preconditions.checkArgument((!this.builderSupplierMap.containsKey(builderClass) ? 1 : 0) != 0, (Object)"Already registered a builder supplier!");
        this.builderSupplierMap.put(builderClass, supplier);
        return this;
    }

    public <T extends CatalogType> Optional<CatalogRegistryModule<T>> getRegistryModuleFor(Class<T> catalogClass) {
        Preconditions.checkNotNull(catalogClass);
        return Optional.ofNullable(this.catalogRegistryMap.get(catalogClass));
    }

    public <TUnknown, T extends CatalogType> T getTranslated(Class<TUnknown> clazz, Class<T> catalogClazz) {
        CatalogRegistryModule module = this.getRegistryModuleFor(catalogClazz).orElse(null);
        Preconditions.checkArgument((boolean)(module instanceof ExtraClassCatalogRegistryModule));
        ExtraClassCatalogRegistryModule classModule = (ExtraClassCatalogRegistryModule)module;
        return classModule.getForClass(clazz);
    }

    @Override
    public <T extends CatalogType> Optional<T> getType(Class<T> typeClass, String id) {
        CatalogRegistryModule registryModule = this.getRegistryModuleFor(typeClass).orElse(null);
        if (registryModule == null) {
            return Optional.empty();
        }
        return registryModule.getById(id.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public <T extends CatalogType> Collection<T> getAllOf(Class<T> typeClass) {
        CatalogRegistryModule registryModule = this.getRegistryModuleFor(typeClass).orElse(null);
        if (registryModule == null) {
            return Collections.emptyList();
        }
        return registryModule.getAll();
    }

    @Override
    public <T extends CatalogType> Collection<T> getAllFor(String pluginId, Class<T> typeClass) {
        Preconditions.checkNotNull((Object)pluginId);
        CatalogRegistryModule registryModule = this.getRegistryModuleFor(typeClass).orElse(null);
        if (registryModule == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        registryModule.getAll().stream().filter(type -> pluginId.equals(type.getId().split(":")[0])).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public <T extends ResettableBuilder<?, ? super T>> T createBuilder(Class<T> builderClass) {
        Preconditions.checkNotNull(builderClass, (Object)"Builder class was null!");
        Supplier<?> supplier = this.builderSupplierMap.get(builderClass);
        if (supplier == null) {
            throw new IllegalArgumentException("Could not find a Supplier for the provided builder class: " + builderClass.getCanonicalName());
        }
        return (T)((ResettableBuilder)supplier.get());
    }

    @Override
    public <T extends CatalogType> T register(Class<T> type, T obj) throws IllegalArgumentException, UnsupportedOperationException {
        CatalogRegistryModule registryModule = this.getRegistryModuleFor(type).orElse(null);
        if (registryModule == null) {
            throw new UnsupportedOperationException("Failed to find a RegistryModule for that type");
        }
        if (registryModule instanceof SpongeAdditionalCatalogRegistryModule) {
            if (((SpongeAdditionalCatalogRegistryModule)registryModule).allowsApiRegistration()) {
                ((SpongeAdditionalCatalogRegistryModule)registryModule).registerAdditionalCatalog(obj);
                return obj;
            }
        } else if (registryModule instanceof AdditionalCatalogRegistryModule) {
            ((AdditionalCatalogRegistryModule)registryModule).registerAdditionalCatalog(obj);
            return obj;
        }
        throw new UnsupportedOperationException("This catalog type does not support additional registration");
    }

    public List<String> getDefaultGameRules() {
        ArrayList<String> gameruleList = new ArrayList<String>();
        for (Field f : DefaultGameRules.class.getFields()) {
            try {
                gameruleList.add((String)f.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return gameruleList;
    }

    @Override
    public AITaskType registerAITaskType(Object plugin, String id, String name, Class<? extends AbstractAITask<? extends Agent>> aiClass) {
        return AITaskTypeModule.getInstance().createAITaskType(plugin, id, name, aiClass);
    }

    @Override
    public Optional<Rotation> getRotationFromDegree(int degrees) {
        for (Rotation rotation : RotationRegistryModule.rotationMap.values()) {
            if (rotation.getAngle() != degrees) continue;
            return Optional.of(rotation);
        }
        return Optional.empty();
    }

    @Override
    public Favicon loadFavicon(String raw) throws IOException {
        return SpongeFavicon.load(raw);
    }

    @Override
    public Favicon loadFavicon(Path path) throws IOException {
        return SpongeFavicon.load(path);
    }

    @Override
    public Favicon loadFavicon(URL url) throws IOException {
        return SpongeFavicon.load(url);
    }

    @Override
    public Favicon loadFavicon(InputStream in) throws IOException {
        return SpongeFavicon.load(in);
    }

    @Override
    public Favicon loadFavicon(BufferedImage image) throws IOException {
        return SpongeFavicon.load(image);
    }

    @Override
    public RecipeRegistry getRecipeRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<Translation> getTranslationById(String id) {
        return Optional.of(new SpongeTranslation(id));
    }

    @Override
    public Optional<EntityStatistic> getEntityStatistic(StatisticGroup statisticGroup, EntityType entityType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<ItemStatistic> getItemStatistic(StatisticGroup statisticGroup, ItemType itemType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<BlockStatistic> getBlockStatistic(StatisticGroup statisticGroup, BlockType blockType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<TeamStatistic> getTeamStatistic(StatisticGroup statisticGroup, TextColor teamColor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Statistic> getStatistics(StatisticGroup statisticGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<ResourcePack> getResourcePackById(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<DisplaySlot> getDisplaySlotForColor(TextColor color) {
        return Optional.ofNullable(DisplaySlotRegistryModule.getInstance().displaySlotMappings.get(color.getId()));
    }

    @Override
    public ExtentBufferFactory getExtentBufferFactory() {
        return SpongeExtentBufferFactory.INSTANCE;
    }

    @Override
    public ValueFactory getValueFactory() {
        return SpongeValueFactory.getInstance();
    }

    @Override
    public VillagerRegistry getVillagerRegistry() {
        return SpongeVillagerRegistry.getInstance();
    }

    @Override
    public TextSerializerFactory getTextSerializerFactory() {
        return SpongeTextSerializerFactory.INSTANCE;
    }

    @Override
    public SpongeSelectorFactory getSelectorFactory() {
        return SpongeSelectorFactory.INSTANCE;
    }

    @Override
    public Locale getLocale(String locale) {
        return (Locale)LanguageUtil.LOCALE_CACHE.getUnchecked((Object)locale);
    }

    private void registerModulePhase() {
        for (Class<? extends RegistryModule> moduleClass : this.orderedModules) {
            if (!this.classMap.containsKey(moduleClass)) {
                throw new IllegalStateException("Something funky happened!");
            }
            RegistryModule module = this.classMap.get(moduleClass);
            RegistryModuleLoader.tryModulePhaseRegistration(module);
        }
        this.registerAdditionalPhase();
    }

    private void registerAdditionalPhase() {
        for (Class<? extends RegistryModule> moduleClass : this.orderedModules) {
            RegistryModule module = this.classMap.get(moduleClass);
            RegistryModuleLoader.tryAdditionalRegistration(module);
        }
    }

    private void addToGraph(RegistryModule module, DirectedGraph<Class<? extends RegistryModule>> graph) {
        graph.add(module.getClass());
        RegistrationDependency dependency = module.getClass().getAnnotation(RegistrationDependency.class);
        if (dependency != null) {
            for (Class<? extends RegistryModule> dependent : dependency.value()) {
                graph.addEdge((Class<? extends RegistryModule>)Preconditions.checkNotNull(module.getClass(), (Object)"Dependency class was null!"), dependent);
            }
        }
    }

    public void preInit() {
        this.phase = RegistrationPhase.PRE_INIT;
        this.registerModulePhase();
    }

    public void init() {
        this.phase = RegistrationPhase.INIT;
        this.registerModulePhase();
    }

    public void postInit() {
        this.phase = RegistrationPhase.POST_INIT;
        this.registerModulePhase();
        SpongePropertyRegistry.completeRegistration();
        SpongeDataManager.finalizeRegistration();
        this.phase = RegistrationPhase.LOADED;
    }

    public void registerAdditionals() {
        this.registerAdditionalPhase();
    }

    static {
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(CatalogType.class), new CatalogTypeTypeSerializer());
    }
}

