/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.data.type.Careers;
import org.spongepowered.api.item.merchant.TradeOfferListMutator;
import org.spongepowered.api.item.merchant.VillagerRegistry;

public final class SpongeVillagerRegistry
implements VillagerRegistry {
    private final Map<Career, Multimap<Integer, TradeOfferListMutator>> careerGeneratorMap = new HashMap<Career, Multimap<Integer, TradeOfferListMutator>>();

    public static SpongeVillagerRegistry getInstance() {
        return Holder.INSTANCE;
    }

    SpongeVillagerRegistry() {
    }

    @Override
    public Multimap<Integer, TradeOfferListMutator> getTradeOfferLevelMap(Career career) {
        Multimap<Integer, TradeOfferListMutator> multimap = this.careerGeneratorMap.get(Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!"));
        if (multimap == null) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.copyOf(multimap);
    }

    @Override
    public VillagerRegistry addMutator(Career career, int level, TradeOfferListMutator generator) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Career level must be at least greater than zero!");
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull((Object)generator, (Object)"Generator cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        if (multimap == null) {
            multimap = ArrayListMultimap.create((int)3, (int)3);
            this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        }
        multimap.put((Object)level, (Object)generator);
        return this;
    }

    @Override
    public VillagerRegistry addMutators(Career career, int level, TradeOfferListMutator generator, TradeOfferListMutator ... generators) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Career level must be at least greater than zero!");
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull((Object)generator, (Object)"Generator cannot be null!");
        Preconditions.checkNotNull((Object)generators, (Object)"Generators cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(generator);
        for (TradeOfferListMutator element : generators) {
            list.add(Preconditions.checkNotNull((Object)element, (Object)"TradeOfferListMutator cannot be null!"));
        }
        if (multimap == null) {
            multimap = ArrayListMultimap.create((int)3, (int)list.size());
            this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        }
        multimap.putAll((Object)level, list);
        return this;
    }

    @Override
    public VillagerRegistry setMutators(Career career, int level, List<TradeOfferListMutator> generators) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Career level must be at least greater than zero!");
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull(generators, (Object)"Generators cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        if (multimap == null) {
            multimap = ArrayListMultimap.create((int)3, (int)generators.size());
            this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        }
        multimap.replaceValues((Object)level, generators);
        return this;
    }

    @Override
    public VillagerRegistry setMutators(Career career, Multimap<Integer, TradeOfferListMutator> generatorMap) {
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull(generatorMap, (Object)"Generators cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        if (multimap != null) {
            multimap.clear();
        }
        multimap = ArrayListMultimap.create(generatorMap);
        this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        return this;
    }

    static void registerVanillaTrades() {
        SpongeVillagerRegistry instance = SpongeVillagerRegistry.getInstance();
        instance.setMutators(Careers.FARMER, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151015_O, new EntityVillager.PriceInfo(18, 22))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151174_bG, new EntityVillager.PriceInfo(15, 19))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151172_bF, new EntityVillager.PriceInfo(15, 19))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151025_P, new EntityVillager.PriceInfo(-4, -2))))).setMutators(Careers.FARMER, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Item.func_150898_a((Block)Blocks.field_150423_aK), new EntityVillager.PriceInfo(8, 13))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151158_bO, new EntityVillager.PriceInfo(-3, -2))))).setMutators(Careers.FARMER, 3, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Item.func_150898_a((Block)Blocks.field_150440_ba), new EntityVillager.PriceInfo(7, 12))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151034_e, new EntityVillager.PriceInfo(-5, -7))))).setMutators(Careers.FARMER, 4, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151106_aX, new EntityVillager.PriceInfo(-6, -10))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151105_aU, new EntityVillager.PriceInfo(1, 1)))));
        instance.setMutators(Careers.FISHERMAN, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151007_F, new EntityVillager.PriceInfo(15, 20))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ItemAndEmeraldToItem(Items.field_151115_aP, new EntityVillager.PriceInfo(6, 6), Items.field_179566_aV, new EntityVillager.PriceInfo(6, 6))))).setMutators(Careers.FISHERMAN, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedItemForEmeralds((Item)Items.field_151112_aM, new EntityVillager.PriceInfo(7, 8)))));
        instance.setMutators(Careers.SHEPHERD, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Item.func_150898_a((Block)Blocks.field_150325_L), new EntityVillager.PriceInfo(16, 22))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds((Item)Items.field_151097_aZ, new EntityVillager.PriceInfo(3, 4))))).setMutators(Careers.SHEPHERD, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 0), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 1), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 2), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 3), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 4), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 5), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 6), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 7), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 8), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 9), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 10), new EntityVillager.PriceInfo(1, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 11), new EntityVillager.PriceInfo(1, 2))), (Object[])new TradeOfferListMutator[]{SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 12), new EntityVillager.PriceInfo(1, 2))), SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 13), new EntityVillager.PriceInfo(1, 2))), SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 14), new EntityVillager.PriceInfo(1, 2))), SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Blocks.field_150325_L, 1, 15), new EntityVillager.PriceInfo(1, 2)))}));
        instance.setMutators(Careers.FLETCHER, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151007_F, new EntityVillager.PriceInfo(15, 20))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151032_g, new EntityVillager.PriceInfo(-12, -8))))).setMutators(Careers.FLETCHER, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds((Item)Items.field_151031_f, new EntityVillager.PriceInfo(2, 3))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ItemAndEmeraldToItem(Item.func_150898_a((Block)Blocks.field_150351_n), new EntityVillager.PriceInfo(10, 10), Items.field_151145_ak, new EntityVillager.PriceInfo(6, 10)))));
        instance.setMutators(Careers.LIBRARIAN, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151121_aF, new EntityVillager.PriceInfo(24, 36))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedBookForEmeralds()))).setMutators(Careers.LIBRARIAN, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151122_aG, new EntityVillager.PriceInfo(8, 10))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151111_aL, new EntityVillager.PriceInfo(10, 12))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)Blocks.field_150342_X), new EntityVillager.PriceInfo(3, 4))))).setMutators(Careers.LIBRARIAN, 3, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151164_bB, new EntityVillager.PriceInfo(2, 2))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151113_aN, new EntityVillager.PriceInfo(10, 12))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)Blocks.field_150359_w), new EntityVillager.PriceInfo(-5, -3))))).setMutators(Careers.LIBRARIAN, 4, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedBookForEmeralds()))).setMutators(Careers.LIBRARIAN, 5, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedBookForEmeralds()))).setMutators(Careers.LIBRARIAN, 6, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151057_cb, new EntityVillager.PriceInfo(20, 22)))));
        instance.setMutators(Careers.CLERIC, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151078_bh, new EntityVillager.PriceInfo(36, 40))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151043_k, new EntityVillager.PriceInfo(8, 10))))).setMutators(Careers.CLERIC, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151137_ax, new EntityVillager.PriceInfo(-4, -1))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), new EntityVillager.PriceInfo(-2, -1))))).setMutators(Careers.CLERIC, 3, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151061_bv, new EntityVillager.PriceInfo(7, 11))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)Blocks.field_150426_aN), new EntityVillager.PriceInfo(-3, -1))))).setMutators(Careers.CLERIC, 4, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151062_by, new EntityVillager.PriceInfo(3, 11)))));
        instance.setMutators(Careers.ARMORER, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds((Item)Items.field_151028_Y, new EntityVillager.PriceInfo(4, 6))))).setMutators(Careers.ARMORER, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151042_j, new EntityVillager.PriceInfo(7, 9))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds((Item)Items.field_151030_Z, new EntityVillager.PriceInfo(10, 14))))).setMutators(Careers.ARMORER, 3, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151045_i, new EntityVillager.PriceInfo(3, 4))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedItemForEmeralds((Item)Items.field_151163_ad, new EntityVillager.PriceInfo(16, 19))))).setMutators(Careers.ARMORER, 4, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds((Item)Items.field_151029_X, new EntityVillager.PriceInfo(5, 7))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds((Item)Items.field_151022_W, new EntityVillager.PriceInfo(9, 11))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds((Item)Items.field_151020_U, new EntityVillager.PriceInfo(5, 7))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds((Item)Items.field_151023_V, new EntityVillager.PriceInfo(11, 15)))));
        instance.setMutators(Careers.WEAPON_SMITH, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151036_c, new EntityVillager.PriceInfo(6, 8))))).setMutators(Careers.WEAPON_SMITH, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151042_j, new EntityVillager.PriceInfo(7, 9))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151040_l, new EntityVillager.PriceInfo(9, 10))))).setMutators(Careers.WEAPON_SMITH, 3, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151045_i, new EntityVillager.PriceInfo(3, 4))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151048_u, new EntityVillager.PriceInfo(12, 15))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151056_x, new EntityVillager.PriceInfo(9, 12)))));
        instance.setMutators(Careers.TOOL_SMITH, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151037_a, new EntityVillager.PriceInfo(5, 7))))).setMutators(Careers.TOOL_SMITH, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151042_j, new EntityVillager.PriceInfo(7, 9))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151035_b, new EntityVillager.PriceInfo(9, 11))))).setMutators(Careers.TOOL_SMITH, 3, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151045_i, new EntityVillager.PriceInfo(3, 4))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151046_w, new EntityVillager.PriceInfo(12, 15)))));
        instance.setMutators(Careers.BUTCHER, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151147_al, new EntityVillager.PriceInfo(14, 18))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151076_bf, new EntityVillager.PriceInfo(14, 18))))).setMutators(Careers.BUTCHER, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151157_am, new EntityVillager.PriceInfo(-7, -5))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151077_bg, new EntityVillager.PriceInfo(-8, -6)))));
        instance.setMutators(Careers.LEATHERWORKER, 1, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.EmeraldForItems(Items.field_151116_aA, new EntityVillager.PriceInfo(9, 12))), (Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds((Item)Items.field_151026_S, new EntityVillager.PriceInfo(2, 4))))).setMutators(Careers.LEATHERWORKER, 2, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListEnchantedItemForEmeralds((Item)Items.field_151027_R, new EntityVillager.PriceInfo(7, 12))))).setMutators(Careers.LEATHERWORKER, 3, (List<TradeOfferListMutator>)ImmutableList.of((Object)SpongeVillagerRegistry.generatorFor((EntityVillager.ITradeList)new EntityVillager.ListItemForEmeralds(Items.field_151141_av, new EntityVillager.PriceInfo(8, 10)))));
    }

    private static TradeOfferListMutator generatorFor(EntityVillager.ITradeList iTradeList) {
        return (TradeOfferListMutator)iTradeList;
    }

    static final class Holder {
        static final SpongeVillagerRegistry INSTANCE = new SpongeVillagerRegistry();

        Holder() {
        }
    }
}

