/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.TileEntityBanner;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.BannerPatternShapes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class BannerPatternShapeRegistryModule
implements CatalogRegistryModule<BannerPatternShape> {
    @RegisterCatalog(value=BannerPatternShapes.class)
    private final Map<String, BannerPatternShape> bannerPatternShapeMappings = Maps.newHashMap();

    @Override
    public Optional<BannerPatternShape> getById(String id) {
        return Optional.ofNullable(this.bannerPatternShapeMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<BannerPatternShape> getAll() {
        return ImmutableList.copyOf(this.bannerPatternShapeMappings.values());
    }

    @Override
    public void registerDefaults() {
        for (TileEntityBanner.EnumBannerPattern pattern : TileEntityBanner.EnumBannerPattern.values()) {
            this.bannerPatternShapeMappings.put(pattern.name().toLowerCase(Locale.ENGLISH), (BannerPatternShape)pattern);
            this.bannerPatternShapeMappings.put(pattern.func_177273_b().toLowerCase(Locale.ENGLISH), (BannerPatternShape)pattern);
        }
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (TileEntityBanner.EnumBannerPattern pattern : TileEntityBanner.EnumBannerPattern.values()) {
            if (this.bannerPatternShapeMappings.containsKey(pattern.name())) continue;
            this.bannerPatternShapeMappings.put(pattern.name().toLowerCase(Locale.ENGLISH), (BannerPatternShape)pattern);
            this.bannerPatternShapeMappings.put(pattern.func_177273_b().toLowerCase(Locale.ENGLISH), (BannerPatternShape)pattern);
        }
    }
}

