/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.BooleanTrait;
import org.spongepowered.api.block.trait.BooleanTraits;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class BooleanTraitRegistryModule
implements SpongeAdditionalCatalogRegistryModule<BooleanTrait>,
AlternateCatalogRegistryModule<BooleanTrait> {
    @RegisterCatalog(value=BooleanTraits.class)
    private Map<String, BooleanTrait> booleanTraitMap = new HashMap<String, BooleanTrait>();

    public static BooleanTraitRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(BooleanTrait extraCatalog) {
        this.booleanTraitMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public Optional<BooleanTrait> getById(String id) {
        return Optional.ofNullable(this.booleanTraitMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<BooleanTrait> getAll() {
        return ImmutableList.copyOf(this.booleanTraitMap.values());
    }

    public void registerBlock(String id, BlockType block, BooleanTrait property) {
        Preconditions.checkNotNull((Object)id, (Object)"Id was null!");
        Preconditions.checkNotNull((Object)property, (Object)"Property was null!");
        this.booleanTraitMap.put(id.toLowerCase(Locale.ENGLISH) + "_" + property.getName().toLowerCase(Locale.ENGLISH), property);
        String propertyId = block.getId().toLowerCase(Locale.ENGLISH) + "_" + property.getName().toLowerCase(Locale.ENGLISH);
        this.booleanTraitMap.put(propertyId, property);
    }

    BooleanTraitRegistryModule() {
    }

    @Override
    public Map<String, BooleanTrait> provideCatalogMap() {
        HashMap<String, BooleanTrait> map = new HashMap<String, BooleanTrait>();
        for (Map.Entry<String, BooleanTrait> enumTraitEntry : this.booleanTraitMap.entrySet()) {
            map.put(enumTraitEntry.getKey().replace("minecraft:", ""), enumTraitEntry.getValue());
        }
        return map;
    }

    private static final class Holder {
        static final BooleanTraitRegistryModule INSTANCE = new BooleanTraitRegistryModule();

        private Holder() {
        }
    }
}

