/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.EnumTrait;
import org.spongepowered.api.block.trait.EnumTraits;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class EnumTraitRegistryModule
implements SpongeAdditionalCatalogRegistryModule<EnumTrait<?>>,
AlternateCatalogRegistryModule<EnumTrait<?>> {
    @RegisterCatalog(value=EnumTraits.class)
    private Map<String, EnumTrait<?>> enumTraitMap = new HashMap();

    public static EnumTraitRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(EnumTrait<?> extraCatalog) {
        this.enumTraitMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public Optional<EnumTrait<?>> getById(String id) {
        return Optional.ofNullable(this.enumTraitMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<EnumTrait<?>> getAll() {
        return ImmutableList.copyOf(this.enumTraitMap.values());
    }

    public void registerBlock(String id, BlockType block, EnumTrait<?> property) {
        Preconditions.checkNotNull((Object)id, (Object)"Id was null!");
        Preconditions.checkNotNull(property, (Object)"Property was null!");
        this.enumTraitMap.put(id.toLowerCase(Locale.ENGLISH), property);
        String propertyId = block.getId().toLowerCase(Locale.ENGLISH) + "_" + property.getName().toLowerCase(Locale.ENGLISH);
        this.enumTraitMap.put(propertyId, property);
    }

    EnumTraitRegistryModule() {
    }

    @Override
    public Map<String, EnumTrait<?>> provideCatalogMap() {
        HashMap map = new HashMap();
        for (Map.Entry<String, EnumTrait<?>> enumTraitEntry : this.enumTraitMap.entrySet()) {
            map.put(enumTraitEntry.getKey().replace("minecraft:", ""), enumTraitEntry.getValue());
        }
        return map;
    }

    private static final class Holder {
        static final EnumTraitRegistryModule INSTANCE = new EnumTraitRegistryModule();

        private Holder() {
        }
    }
}

