/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.IntegerTrait;
import org.spongepowered.api.block.trait.IntegerTraits;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class IntegerTraitRegistryModule
implements SpongeAdditionalCatalogRegistryModule<IntegerTrait>,
AlternateCatalogRegistryModule<IntegerTrait> {
    @RegisterCatalog(value=IntegerTraits.class)
    private Map<String, IntegerTrait> integerTraitMap = new HashMap<String, IntegerTrait>();

    public static IntegerTraitRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(IntegerTrait extraCatalog) {
        this.integerTraitMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public Optional<IntegerTrait> getById(String id) {
        return Optional.ofNullable(this.integerTraitMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<IntegerTrait> getAll() {
        return ImmutableList.copyOf(this.integerTraitMap.values());
    }

    public void registerBlock(String id, BlockType block, IntegerTrait property) {
        Preconditions.checkNotNull((Object)id, (Object)"Id was null!");
        this.integerTraitMap.put(id.toLowerCase(Locale.ENGLISH), property);
        String propertyId = block.getId().toLowerCase(Locale.ENGLISH) + "_" + property.getName().toLowerCase(Locale.ENGLISH);
        this.integerTraitMap.put(propertyId, property);
    }

    IntegerTraitRegistryModule() {
    }

    @Override
    public Map<String, IntegerTrait> provideCatalogMap() {
        HashMap<String, IntegerTrait> map = new HashMap<String, IntegerTrait>();
        for (Map.Entry<String, IntegerTrait> enumTraitEntry : this.integerTraitMap.entrySet()) {
            map.put(enumTraitEntry.getKey().replace("minecraft:", ""), enumTraitEntry.getValue());
        }
        return map;
    }

    private static final class Holder {
        static final IntegerTraitRegistryModule INSTANCE = new IntegerTraitRegistryModule();

        private Holder() {
        }
    }
}

