/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.SkullType;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeSkullType;

public final class SkullTypeRegistryModule
implements CatalogRegistryModule<SkullType> {
    @RegisterCatalog(value=SkullTypes.class)
    private final Map<String, SkullType> skullTypeMap = new LinkedHashMap<String, SkullType>();

    @Override
    public Optional<SkullType> getById(String id) {
        return Optional.ofNullable(this.skullTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<SkullType> getAll() {
        return ImmutableList.copyOf(this.skullTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.skullTypeMap.put("skeleton", new SpongeSkullType(0, "skeleton"));
        this.skullTypeMap.put("wither_skeleton", new SpongeSkullType(1, "wither_skeleton"));
        this.skullTypeMap.put("zombie", new SpongeSkullType(2, "zombie"));
        this.skullTypeMap.put("player", new SpongeSkullType(3, "player"));
        this.skullTypeMap.put("creeper", new SpongeSkullType(4, "creeper"));
        this.skullTypeMap.put("ender_dragon", new SpongeSkullType(5, "ender_dragon"));
    }
}

