/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ITickable;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.block.tileentity.TileEntityTypes;
import org.spongepowered.api.registry.ExtraClassCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.data.type.SpongeTileEntityType;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class TileEntityTypeRegistryModule
implements ExtraClassCatalogRegistryModule<TileEntityType, TileEntity>,
SpongeAdditionalCatalogRegistryModule<TileEntityType> {
    private static final Map<String, String> NAME_TO_ID_MAPPING = ImmutableMap.builder().put((Object)"Cauldron", (Object)"brewing_stand").put((Object)"Control", (Object)"command_block").put((Object)"DLDetector", (Object)"daylight_detector").put((Object)"Trap", (Object)"dispenser").put((Object)"EnchantTable", (Object)"enchantment_table").put((Object)"EnderChest", (Object)"ender_chest").put((Object)"Airportal", (Object)"end_portal").put((Object)"FlowerPot", (Object)"flower_pot").put((Object)"RecordPlayer", (Object)"jukebox").put((Object)"MobSpawner", (Object)"mob_spawner").put((Object)"Music", (Object)"note").put((Object)"EndGateway", (Object)"end_gateway").build();
    public final Map<Class<? extends TileEntity>, TileEntityType> tileClassToTypeMappings = Maps.newHashMap();
    @RegisterCatalog(value=TileEntityTypes.class)
    public final Map<String, TileEntityType> tileEntityTypeMappings = Maps.newHashMap();

    public static TileEntityTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(TileEntityType extraCatalog) {
        this.tileClassToTypeMappings.put(extraCatalog.getTileEntityType(), extraCatalog);
        this.tileEntityTypeMappings.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public boolean hasRegistrationFor(Class<? extends TileEntity> mappedClass) {
        return this.tileClassToTypeMappings.containsKey(mappedClass);
    }

    @Override
    public TileEntityType getForClass(Class<? extends TileEntity> clazz) {
        return this.tileClassToTypeMappings.get(clazz);
    }

    @Override
    public Optional<TileEntityType> getById(String id) {
        return Optional.ofNullable(this.tileEntityTypeMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<TileEntityType> getAll() {
        return ImmutableList.copyOf(this.tileEntityTypeMappings.values());
    }

    @Override
    public void registerDefaults() {
        try {
            Class<?> clazz = Class.forName("net.minecraft.tileentity.TileEntity");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getIdForName(String name) {
        String id = NAME_TO_ID_MAPPING.get(name);
        return id == null ? name : id;
    }

    public void doTileEntityRegistration(Class<?> clazz, String name) {
        String id = TileEntityTypeRegistryModule.getInstance().getIdForName(name);
        boolean canTick = true;
        try {
            String mapping;
            Class<?> declaringClazz;
            if (ITickable.class.isAssignableFrom(clazz) && ((declaringClazz = clazz.getMethod(mapping = SpongeImplHooks.isDeobfuscatedEnvironment() ? "update" : "func_73660_a", new Class[0]).getDeclaringClass()).equals(TileEntityChest.class) || declaringClazz.equals(TileEntityEnderChest.class))) {
                canTick = false;
            }
        }
        catch (Throwable mapping) {
            // empty catch block
        }
        SpongeTileEntityType tileEntityType = new SpongeTileEntityType(clazz, name, id, canTick);
        TileEntityTypeRegistryModule.getInstance().registerAdditionalCatalog(tileEntityType);
    }

    TileEntityTypeRegistryModule() {
    }

    private static final class Holder {
        static final TileEntityTypeRegistryModule INSTANCE = new TileEntityTypeRegistryModule();

        private Holder() {
        }
    }
}

