/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.boss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.BossInfo;
import org.spongepowered.api.boss.BossBarColor;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class BossBarColorRegistryModule
implements CatalogRegistryModule<BossBarColor> {
    @RegisterCatalog(value=BossBarColors.class)
    public final Map<String, BossBarColor> colorMap = Maps.newHashMap();

    @Override
    public void registerDefaults() {
        this.colorMap.put("pink", (BossBarColor)BossInfo.Color.PINK);
        this.colorMap.put("blue", (BossBarColor)BossInfo.Color.BLUE);
        this.colorMap.put("red", (BossBarColor)BossInfo.Color.RED);
        this.colorMap.put("green", (BossBarColor)BossInfo.Color.GREEN);
        this.colorMap.put("yellow", (BossBarColor)BossInfo.Color.YELLOW);
        this.colorMap.put("purple", (BossBarColor)BossInfo.Color.PURPLE);
        this.colorMap.put("white", (BossBarColor)BossInfo.Color.WHITE);
    }

    @Override
    public Optional<BossBarColor> getById(String id) {
        return Optional.ofNullable(this.colorMap.get(((String)Preconditions.checkNotNull((Object)id, (Object)"id")).toLowerCase()));
    }

    @Override
    public Collection<BossBarColor> getAll() {
        return ImmutableSet.copyOf(this.colorMap.values());
    }

    @AdditionalRegistration
    public void customRegistration() {
        for (BossInfo.Color color : BossInfo.Color.values()) {
            if (this.colorMap.containsKey(color.name().toLowerCase())) continue;
            this.colorMap.put(color.name().toLowerCase(), (BossBarColor)color);
        }
    }
}

