/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.EnumHand;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public class HandTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<HandType> {
    @RegisterCatalog(value=HandTypes.class)
    private final Map<String, HandType> handTypeMap = new HashMap<String, HandType>();

    public static HandTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(HandType extraCatalog) {
        throw new UnsupportedOperationException("Cannot register additional HandTypes!!!");
    }

    @Override
    public Optional<HandType> getById(String id) {
        return Optional.ofNullable(this.handTypeMap.get(((String)Preconditions.checkNotNull((Object)id, (Object)"Id cannot be null")).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<HandType> getAll() {
        return ImmutableSet.copyOf(this.handTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        for (EnumHand enumHand : EnumHand.values()) {
            this.handTypeMap.put(enumHand.name().toLowerCase(Locale.ENGLISH), (HandType)enumHand);
        }
    }

    HandTypeRegistryModule() {
    }

    static final class Holder {
        static final HandTypeRegistryModule INSTANCE = new HandTypeRegistryModule();

        Holder() {
        }
    }
}

