/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.economy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.service.economy.transaction.TransactionType;
import org.spongepowered.api.service.economy.transaction.TransactionTypes;
import org.spongepowered.common.economy.SpongeTransactionType;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public class TransactionTypeRegistryModule
implements CatalogRegistryModule<TransactionType>,
SpongeAdditionalCatalogRegistryModule<TransactionType> {
    @RegisterCatalog(value=TransactionTypes.class)
    public final Map<String, TransactionType> transactionTypeMappings = new HashMap<String, TransactionType>();

    @Override
    public Optional<TransactionType> getById(String id) {
        return Optional.ofNullable(this.transactionTypeMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<TransactionType> getAll() {
        return ImmutableList.copyOf(this.transactionTypeMappings.values());
    }

    @Override
    public boolean allowsApiRegistration() {
        return true;
    }

    @Override
    public void registerAdditionalCatalog(TransactionType extraCatalog) {
        this.transactionTypeMappings.put(((TransactionType)Preconditions.checkNotNull((Object)extraCatalog)).getId(), extraCatalog);
    }

    @Override
    public void registerDefaults() {
        this.transactionTypeMappings.put("deposit", new SpongeTransactionType("deposit"));
        this.transactionTypeMappings.put("withdraw", new SpongeTransactionType("withdraw"));
        this.transactionTypeMappings.put("transfer", new SpongeTransactionType("transfer"));
    }
}

