/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.effect;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.effect.particle.SpongeParticleOption;

public class ParticleOptionRegistryModule
implements CatalogRegistryModule<ParticleOption> {
    @RegisterCatalog(value=ParticleOptions.class)
    private final Map<String, ParticleOption> particleOptionsMappings = new HashMap<String, ParticleOption>();
    private final Map<String, ParticleOption> particleOptions = new HashMap<String, ParticleOption>();

    @Override
    public Optional<ParticleOption> getById(String id) {
        return Optional.ofNullable(this.particleOptions.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<ParticleOption> getAll() {
        return ImmutableList.copyOf(this.particleOptions.values());
    }

    @Override
    public void registerDefaults() {
        this.registerOption("block_state", BlockState.class);
        this.registerOption("color", Color.class);
        this.registerOption("direction", Direction.class);
        this.registerOption("firework_effects", List.class, value -> value.isEmpty() ? new IllegalArgumentException("The firework effects list may not be empty") : null);
        this.registerOption("quantity", Integer.class, value -> value < 1 ? new IllegalArgumentException("Quantity must be at least 1") : null);
        this.registerOption("item_stack_snapshot", ItemStackSnapshot.class);
        this.registerOption("note", NotePitch.class);
        this.registerOption("offset", Vector3d.class);
        this.registerOption("potion_effect_type", PotionEffectType.class);
        this.registerOption("scale", Double.class, value -> value < 0.0 ? new IllegalArgumentException("Scale may not be negative") : null);
        this.registerOption("velocity", Vector3d.class);
        this.registerOption("slow_horizontal_velocity", Boolean.class);
    }

    private <V> void registerOption(String id, Class<V> valueType) {
        this.registerOption(id, valueType, null);
    }

    private <V> void registerOption(String id, Class<V> valueType, @Nullable Function<V, IllegalArgumentException> valueValidator) {
        SpongeParticleOption<V> option = new SpongeParticleOption<V>("minecraft:" + id, id, valueType, valueValidator);
        this.particleOptionsMappings.put(id, option);
        this.particleOptions.put(id, option);
    }
}

