/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.spongepowered.api.entity.ai.task.AITask;
import org.spongepowered.api.entity.ai.task.AITaskType;
import org.spongepowered.api.entity.ai.task.AITaskTypes;
import org.spongepowered.api.entity.ai.task.builtin.SwimmingAITask;
import org.spongepowered.api.entity.ai.task.builtin.WatchClosestAITask;
import org.spongepowered.api.entity.ai.task.builtin.creature.AttackLivingAITask;
import org.spongepowered.api.entity.ai.task.builtin.creature.AvoidEntityAITask;
import org.spongepowered.api.entity.ai.task.builtin.creature.WanderAITask;
import org.spongepowered.api.entity.ai.task.builtin.creature.horse.RunAroundLikeCrazyAITask;
import org.spongepowered.api.entity.ai.task.builtin.creature.target.FindNearestAttackableTargetAITask;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.ai.SpongeAITaskType;

public class AITaskTypeModule
implements AlternateCatalogRegistryModule<AITaskType> {
    @RegisterCatalog(value=AITaskTypes.class)
    private final Map<String, AITaskType> aiTaskTypes = new ConcurrentHashMap<String, AITaskType>();

    public static AITaskTypeModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, AITaskType> provideCatalogMap() {
        HashMap<String, AITaskType> aiMap = new HashMap<String, AITaskType>();
        for (Map.Entry<String, AITaskType> entry : this.aiTaskTypes.entrySet()) {
            aiMap.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return aiMap;
    }

    @Override
    public Optional<AITaskType> getById(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.aiTaskTypes.get(id.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<AITaskType> getAll() {
        return ImmutableList.copyOf(this.aiTaskTypes.values());
    }

    public Optional<AITaskType> getByAIClass(Class<?> clazz) {
        for (AITaskType type : this.aiTaskTypes.values()) {
            if (!type.getAIClass().isAssignableFrom(clazz)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    @Override
    public void registerDefaults() {
        this.createAITaskType(SpongeImpl.getMinecraftPlugin(), "wander", "Wander", WanderAITask.class);
        this.createAITaskType(SpongeImpl.getMinecraftPlugin(), "avoid_entity", "Avoid Entity", AvoidEntityAITask.class);
        this.createAITaskType(SpongeImpl.getMinecraftPlugin(), "run_around_like_crazy", "Run Around Like Crazy", RunAroundLikeCrazyAITask.class);
        this.createAITaskType(SpongeImpl.getMinecraftPlugin(), "swimming", "Swimming", SwimmingAITask.class);
        this.createAITaskType(SpongeImpl.getMinecraftPlugin(), "watch_closest", "Watch Closest", WatchClosestAITask.class);
        this.createAITaskType(SpongeImpl.getMinecraftPlugin(), "find_nearest_attackable_target", "Find Nearest Attackable Target", FindNearestAttackableTargetAITask.class);
        this.createAITaskType(SpongeImpl.getMinecraftPlugin(), "attack_living", "Attack Living", AttackLivingAITask.class);
    }

    public AITaskType createAITaskType(Object plugin, String id, String name, Class<? extends AITask<? extends Agent>> aiClass) {
        Optional<PluginContainer> optPluginContainer = SpongeImpl.getGame().getPluginManager().fromInstance(plugin);
        Preconditions.checkArgument((boolean)optPluginContainer.isPresent());
        PluginContainer pluginContainer = optPluginContainer.get();
        String combinedId = pluginContainer.getId().toLowerCase(Locale.ENGLISH) + ":" + id;
        SpongeAITaskType newType = new SpongeAITaskType(combinedId, name, aiClass);
        this.aiTaskTypes.put(combinedId, newType);
        return newType;
    }

    AITaskTypeModule() {
    }

    private static final class Holder {
        static final AITaskTypeModule INSTANCE = new AITaskTypeModule();

        private Holder() {
        }
    }
}

