/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.effect.EntityWeatherEffect;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityFishHook;
import org.spongepowered.api.data.type.HorseColors;
import org.spongepowered.api.data.type.HorseStyles;
import org.spongepowered.api.data.type.HorseVariants;
import org.spongepowered.api.data.type.OcelotTypes;
import org.spongepowered.api.data.type.RabbitTypes;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.registry.ExtraClassCatalogRegistryModule;
import org.spongepowered.api.registry.util.CustomCatalogRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.SpongeEntityConstants;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.entity.living.human.EntityHuman;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.text.translation.SpongeTranslation;

public final class EntityTypeRegistryModule
implements ExtraClassCatalogRegistryModule<EntityType, Entity>,
SpongeAdditionalCatalogRegistryModule<EntityType> {
    @RegisterCatalog(value=EntityTypes.class)
    protected final Map<String, EntityType> entityTypeMappings = Maps.newHashMap();
    public final Map<Class<? extends Entity>, EntityType> entityClassToTypeMappings = Maps.newHashMap();

    public static EntityTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    public void registerEntityType(EntityType type) {
        this.entityTypeMappings.put(type.getId(), type);
        this.entityClassToTypeMappings.put(((SpongeEntityType)type).entityClass, type);
    }

    @Override
    public Optional<EntityType> getById(String id) {
        if (!((String)Preconditions.checkNotNull((Object)id)).contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.entityTypeMappings.get(id.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<EntityType> getAll() {
        return ImmutableList.copyOf(this.entityTypeMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.entityTypeMappings.put("item", this.newEntityTypeFromName("Item"));
        this.entityTypeMappings.put("experience_orb", this.newEntityTypeFromName("XPOrb"));
        this.entityTypeMappings.put("area_effect_cloud", this.newEntityTypeFromName("AreaEffectCloud"));
        this.entityTypeMappings.put("dragon_fireball", this.newEntityTypeFromName("DragonFireball"));
        this.entityTypeMappings.put("leash_hitch", this.newEntityTypeFromName("LeashKnot"));
        this.entityTypeMappings.put("painting", this.newEntityTypeFromName("Painting"));
        this.entityTypeMappings.put("tipped_arrow", this.newEntityTypeFromName("Arrow"));
        this.entityTypeMappings.put("snowball", this.newEntityTypeFromName("Snowball"));
        this.entityTypeMappings.put("fireball", this.newEntityTypeFromName("LargeFireball", "Fireball"));
        this.entityTypeMappings.put("small_fireball", this.newEntityTypeFromName("SmallFireball"));
        this.entityTypeMappings.put("ender_pearl", this.newEntityTypeFromName("ThrownEnderpearl"));
        this.entityTypeMappings.put("eye_of_ender", this.newEntityTypeFromName("EyeOfEnderSignal"));
        this.entityTypeMappings.put("splash_potion", this.newEntityTypeFromName("ThrownPotion"));
        this.entityTypeMappings.put("thrown_exp_bottle", this.newEntityTypeFromName("ThrownExpBottle"));
        this.entityTypeMappings.put("item_frame", this.newEntityTypeFromName("ItemFrame"));
        this.entityTypeMappings.put("wither_skull", this.newEntityTypeFromName("WitherSkull"));
        this.entityTypeMappings.put("primed_tnt", this.newEntityTypeFromName("PrimedTnt"));
        this.entityTypeMappings.put("falling_block", this.newEntityTypeFromName("FallingSand"));
        this.entityTypeMappings.put("firework", this.newEntityTypeFromName("FireworksRocketEntity"));
        this.entityTypeMappings.put("armor_stand", this.newEntityTypeFromName("ArmorStand"));
        this.entityTypeMappings.put("boat", this.newEntityTypeFromName("Boat"));
        this.entityTypeMappings.put("rideable_minecart", this.newEntityTypeFromName("MinecartRideable"));
        this.entityTypeMappings.put("chested_minecart", this.newEntityTypeFromName("MinecartChest"));
        this.entityTypeMappings.put("furnace_minecart", this.newEntityTypeFromName("MinecartFurnace"));
        this.entityTypeMappings.put("tnt_minecart", this.newEntityTypeFromName("MinecartTnt", "MinecartTNT"));
        this.entityTypeMappings.put("hopper_minecart", this.newEntityTypeFromName("MinecartHopper"));
        this.entityTypeMappings.put("mob_spawner_minecart", this.newEntityTypeFromName("MinecartSpawner"));
        this.entityTypeMappings.put("commandblock_minecart", this.newEntityTypeFromName("MinecartCommandBlock"));
        this.entityTypeMappings.put("creeper", this.newEntityTypeFromName("Creeper"));
        this.entityTypeMappings.put("skeleton", this.newEntityTypeFromName("Skeleton"));
        this.entityTypeMappings.put("spider", this.newEntityTypeFromName("Spider"));
        this.entityTypeMappings.put("giant", this.newEntityTypeFromName("Giant"));
        this.entityTypeMappings.put("zombie", this.newEntityTypeFromName("Zombie"));
        this.entityTypeMappings.put("slime", this.newEntityTypeFromName("Slime"));
        this.entityTypeMappings.put("ghast", this.newEntityTypeFromName("Ghast"));
        this.entityTypeMappings.put("pig_zombie", this.newEntityTypeFromName("PigZombie"));
        this.entityTypeMappings.put("enderman", this.newEntityTypeFromName("Enderman"));
        this.entityTypeMappings.put("cave_spider", this.newEntityTypeFromName("CaveSpider"));
        this.entityTypeMappings.put("silverfish", this.newEntityTypeFromName("Silverfish"));
        this.entityTypeMappings.put("blaze", this.newEntityTypeFromName("Blaze"));
        this.entityTypeMappings.put("magma_cube", this.newEntityTypeFromName("LavaSlime"));
        this.entityTypeMappings.put("ender_dragon", this.newEntityTypeFromName("EnderDragon"));
        this.entityTypeMappings.put("wither", this.newEntityTypeFromName("WitherBoss"));
        this.entityTypeMappings.put("bat", this.newEntityTypeFromName("Bat"));
        this.entityTypeMappings.put("witch", this.newEntityTypeFromName("Witch"));
        this.entityTypeMappings.put("endermite", this.newEntityTypeFromName("Endermite"));
        this.entityTypeMappings.put("guardian", this.newEntityTypeFromName("Guardian"));
        this.entityTypeMappings.put("pig", this.newEntityTypeFromName("Pig"));
        this.entityTypeMappings.put("sheep", this.newEntityTypeFromName("Sheep"));
        this.entityTypeMappings.put("cow", this.newEntityTypeFromName("Cow"));
        this.entityTypeMappings.put("chicken", this.newEntityTypeFromName("Chicken"));
        this.entityTypeMappings.put("squid", this.newEntityTypeFromName("Squid"));
        this.entityTypeMappings.put("wolf", this.newEntityTypeFromName("Wolf"));
        this.entityTypeMappings.put("mushroom_cow", this.newEntityTypeFromName("MushroomCow"));
        this.entityTypeMappings.put("snowman", this.newEntityTypeFromName("SnowMan"));
        this.entityTypeMappings.put("ocelot", this.newEntityTypeFromName("Ocelot", "Ozelot"));
        this.entityTypeMappings.put("iron_golem", this.newEntityTypeFromName("VillagerGolem"));
        this.entityTypeMappings.put("horse", this.newEntityTypeFromName("EntityHorse"));
        this.entityTypeMappings.put("rabbit", this.newEntityTypeFromName("Rabbit"));
        this.entityTypeMappings.put("villager", this.newEntityTypeFromName("Villager"));
        this.entityTypeMappings.put("ender_crystal", this.newEntityTypeFromName("EnderCrystal"));
        this.entityTypeMappings.put("shulker", this.newEntityTypeFromName("Shulker"));
        this.entityTypeMappings.put("shulker_bullet", this.newEntityTypeFromName("ShulkerBullet"));
        this.entityTypeMappings.put("spectral_arrow", this.newEntityTypeFromName("SpectralArrow"));
        this.entityTypeMappings.put("polar_bear", this.newEntityTypeFromName("PolarBear"));
        this.entityTypeMappings.put("egg", new SpongeEntityType(-1, "Egg", EntityEgg.class, new SpongeTranslation("item.egg.name")));
        this.entityTypeMappings.put("fishing_hook", new SpongeEntityType(-2, "FishingHook", EntityFishHook.class, new SpongeTranslation("item.fishingRod.name")));
        this.entityTypeMappings.put("lightning", new SpongeEntityType(-3, "Lightning", EntityLightningBolt.class, null));
        this.entityTypeMappings.put("weather", new SpongeEntityType(-4, "Weather", EntityWeatherEffect.class, new SpongeTranslation("soundCategory.weather")));
        this.entityTypeMappings.put("player", new SpongeEntityType(-5, "Player", EntityPlayerMP.class, new SpongeTranslation("soundCategory.player")));
        this.entityTypeMappings.put("complex_part", new SpongeEntityType(-6, "ComplexPart", EntityDragonPart.class, null));
        this.entityTypeMappings.put("human", this.registerCustomEntity(EntityHuman.class, "Human", -7, null));
    }

    private SpongeEntityType newEntityTypeFromName(String spongeName, String mcName) {
        return new SpongeEntityType((Integer)EntityList.field_180126_g.get(mcName), spongeName, (Class)EntityList.field_75625_b.get(mcName), new SpongeTranslation("entity." + mcName + ".name"));
    }

    private SpongeEntityType newEntityTypeFromName(String name) {
        return this.newEntityTypeFromName(name, name);
    }

    private SpongeEntityType registerCustomEntity(Class<? extends Entity> entityClass, String entityName, int entityId, Translation translation) {
        String entityFullName = String.format("%s.%s", "Sponge", entityName);
        EntityList.field_75626_c.put(entityClass, entityFullName);
        EntityList.field_75625_b.put(entityFullName, entityClass);
        return new SpongeEntityType(entityId, entityName, "Sponge", entityClass, translation);
    }

    @CustomCatalogRegistration
    public void registerCatalogs() {
        this.registerDefaults();
        RegistryHelper.mapFields(EntityTypes.class, fieldName -> {
            if (fieldName.equals("UNKNOWN")) {
                return SpongeEntityType.UNKNOWN;
            }
            EntityType entityType = this.entityTypeMappings.get(fieldName.toLowerCase(Locale.ENGLISH));
            this.entityClassToTypeMappings.put(((SpongeEntityType)entityType).entityClass, entityType);
            this.entityTypeMappings.remove(fieldName.toLowerCase(Locale.ENGLISH));
            this.entityTypeMappings.put(entityType.getId(), entityType);
            return entityType;
        });
        this.entityTypeMappings.put("minecraft:ozelot", this.entityTypeMappings.get("minecraft:ocelot"));
        RegistryHelper.mapFields(HorseColors.class, SpongeEntityConstants.HORSE_COLORS);
        RegistryHelper.mapFields(HorseVariants.class, SpongeEntityConstants.HORSE_VARIANTS);
        RegistryHelper.mapFields(HorseStyles.class, SpongeEntityConstants.HORSE_STYLES);
        RegistryHelper.mapFields(OcelotTypes.class, SpongeEntityConstants.OCELOT_TYPES);
        RegistryHelper.mapFields(RabbitTypes.class, SpongeEntityConstants.RABBIT_TYPES);
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(EntityType extraCatalog) {
        this.entityTypeMappings.put(extraCatalog.getId(), extraCatalog);
        this.entityClassToTypeMappings.put(((SpongeEntityType)extraCatalog).entityClass, extraCatalog);
    }

    @Override
    public boolean hasRegistrationFor(Class<? extends Entity> mappedClass) {
        return false;
    }

    @Override
    public EntityType getForClass(Class<? extends Entity> clazz) {
        EntityType type = this.entityClassToTypeMappings.get(clazz);
        if (type == null) {
            SpongeImpl.getLogger().warn(String.format("No entity type is registered for class %s", clazz.getName()));
            type = EntityTypes.UNKNOWN;
            this.entityClassToTypeMappings.put(clazz, type);
        }
        return type;
    }

    EntityTypeRegistryModule() {
    }

    public Optional<EntityType> getEntity(Class<? extends org.spongepowered.api.entity.Entity> entityClass) {
        for (EntityType type : this.entityTypeMappings.values()) {
            if (!entityClass.isAssignableFrom(type.getEntityClass())) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    private static final class Holder {
        static final EntityTypeRegistryModule INSTANCE = new EntityTypeRegistryModule();

        private Holder() {
        }
    }
}

