/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.world.GameType;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class GameModeRegistryModule
implements CatalogRegistryModule<GameMode> {
    @RegisterCatalog(value=GameModes.class)
    public final BiMap<String, GameMode> gameModeMappings = HashBiMap.create();

    @Override
    public Optional<GameMode> getById(String id) {
        return Optional.of(this.gameModeMappings.get((Object)((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<GameMode> getAll() {
        return ImmutableList.copyOf((Object[])((GameMode[])GameType.values()));
    }

    @Override
    public void registerDefaults() {
        this.gameModeMappings.put((Object)"survival", (Object)((GameMode)GameType.SURVIVAL));
        this.gameModeMappings.put((Object)"creative", (Object)((GameMode)GameType.CREATIVE));
        this.gameModeMappings.put((Object)"adventure", (Object)((GameMode)GameType.ADVENTURE));
        this.gameModeMappings.put((Object)"spectator", (Object)((GameMode)GameType.SPECTATOR));
        this.gameModeMappings.put((Object)"not_set", (Object)((GameMode)GameType.NOT_SET));
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (GameType gameType : GameType.values()) {
            if (this.gameModeMappings.inverse().containsKey((Object)((GameMode)gameType))) continue;
            this.gameModeMappings.put((Object)gameType.func_77149_b().toLowerCase(Locale.ENGLISH), (Object)((GameMode)gameType));
        }
    }

    public static GameType toGameType(GameMode gamemode) {
        for (GameType gameType : GameType.values()) {
            if (!gameType.func_77149_b().equalsIgnoreCase(gamemode.getId())) continue;
            return gameType;
        }
        return GameType.SURVIVAL;
    }
}

