/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierType;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.event.damage.SpongeDamageModifierType;

public class DamageModifierTypeRegistryModule
implements CatalogRegistryModule<DamageModifierType> {
    @RegisterCatalog(value=DamageModifierTypes.class)
    private final Map<String, DamageModifierType> modifierTypeMap = new HashMap<String, DamageModifierType>();

    @Override
    public Optional<DamageModifierType> getById(String id) {
        return Optional.ofNullable(this.modifierTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<DamageModifierType> getAll() {
        return ImmutableList.copyOf(this.modifierTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.modifierTypeMap.put("weapon_enchantment", new SpongeDamageModifierType("Weapon Enchantment", "weapon_enchantment"));
        this.modifierTypeMap.put("offensive_potion_effect", new SpongeDamageModifierType("Offensive PotionEffect", "offensive_potion_effect"));
        this.modifierTypeMap.put("defensive_potion_effect", new SpongeDamageModifierType("Defensive PotionEffect", "defensive_potion_effect"));
        this.modifierTypeMap.put("negative_potion_effect", new SpongeDamageModifierType("Negative PotionEffect", "negative_potion_effect"));
        this.modifierTypeMap.put("hard_hat", new SpongeDamageModifierType("Hard Hat", "hard_hat"));
        this.modifierTypeMap.put("blocking", new SpongeDamageModifierType("Blocking", "blocking"));
        this.modifierTypeMap.put("armor", new SpongeDamageModifierType("Armor", "armor"));
        this.modifierTypeMap.put("armor_enchantment", new SpongeDamageModifierType("Armor Enchantment", "armor_enchantment"));
        this.modifierTypeMap.put("magic", new SpongeDamageModifierType("Magic", "magic"));
        this.modifierTypeMap.put("difficulty", new SpongeDamageModifierType("Difficulty", "difficulty"));
        this.modifierTypeMap.put("absorption", new SpongeDamageModifierType("Absorption", "absorption"));
        this.modifierTypeMap.put("critical_hit", new SpongeDamageModifierType("Critical Hit", "critical_hit"));
        this.modifierTypeMap.put("attack_cooldown", new SpongeDamageModifierType("Attack Cooldown", "attack_cooldown"));
    }
}

