/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

public class SpawnTypeRegistryModule
implements AdditionalCatalogRegistryModule<SpawnType> {
    @RegisterCatalog(value=SpawnTypes.class)
    private final Map<String, SpawnType> spawnTypeMap = new HashMap<String, SpawnType>();

    @Override
    public void registerAdditionalCatalog(SpawnType extraCatalog) {
        Preconditions.checkArgument((!this.spawnTypeMap.containsKey(extraCatalog.getId().toLowerCase(Locale.ENGLISH)) ? 1 : 0) != 0, (String)"SpawnType with the same id is already registered: {}", (Object[])new Object[]{extraCatalog.getId()});
        this.spawnTypeMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public Optional<SpawnType> getById(String id) {
        return Optional.ofNullable(this.spawnTypeMap.get(((String)Preconditions.checkNotNull((Object)id, (Object)"Id cannot be null!")).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<SpawnType> getAll() {
        return ImmutableSet.copyOf(this.spawnTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.spawnTypeMap.put("block_spawning", InternalSpawnTypes.BLOCK_SPAWNING);
        this.spawnTypeMap.put("breeding", InternalSpawnTypes.BREEDING);
        this.spawnTypeMap.put("dispense", InternalSpawnTypes.DISPENSE);
        this.spawnTypeMap.put("dropped_item", InternalSpawnTypes.DROPPED_ITEM);
        this.spawnTypeMap.put("experience", InternalSpawnTypes.EXPERIENCE);
        this.spawnTypeMap.put("falling_block", InternalSpawnTypes.FALLING_BLOCK);
        this.spawnTypeMap.put("mob_spawner", InternalSpawnTypes.MOB_SPAWNER);
        this.spawnTypeMap.put("passive", InternalSpawnTypes.PASSIVE);
        this.spawnTypeMap.put("placement", InternalSpawnTypes.PLACEMENT);
        this.spawnTypeMap.put("projectile", InternalSpawnTypes.PROJECTILE);
        this.spawnTypeMap.put("spawn_egg", InternalSpawnTypes.SPAWN_EGG);
        this.spawnTypeMap.put("structure", InternalSpawnTypes.STRUCTURE);
        this.spawnTypeMap.put("tnt_ignite", InternalSpawnTypes.TNT_IGNITE);
        this.spawnTypeMap.put("weather", InternalSpawnTypes.WEATHER);
        this.spawnTypeMap.put("custom", InternalSpawnTypes.CUSTOM);
        this.spawnTypeMap.put("chunk_load", InternalSpawnTypes.CHUNK_LOAD);
        this.spawnTypeMap.put("world_spawner", InternalSpawnTypes.WORLD_SPAWNER);
        this.spawnTypeMap.put("plugin", InternalSpawnTypes.PLUGIN);
    }
}

