/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemArmor;
import org.spongepowered.api.data.type.ArmorType;
import org.spongepowered.api.data.type.ArmorTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public class ArmorTypeRegistryModule
implements CatalogRegistryModule<ArmorType> {
    @RegisterCatalog(value=ArmorTypes.class)
    private final Map<String, ArmorType> armorTypeMap = new HashMap<String, ArmorType>();

    @Override
    public Optional<ArmorType> getById(String id) {
        return Optional.ofNullable(this.armorTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<ArmorType> getAll() {
        return ImmutableSet.copyOf(this.armorTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        for (ItemArmor.ArmorMaterial armorMaterial : ItemArmor.ArmorMaterial.values()) {
            this.armorTypeMap.put(armorMaterial.name().toLowerCase(Locale.ENGLISH), (ArmorType)armorMaterial);
        }
    }

    @AdditionalRegistration
    public void customRegistration() {
        for (ItemArmor.ArmorMaterial armorMaterial : ItemArmor.ArmorMaterial.values()) {
            if (this.armorTypeMap.containsKey(armorMaterial.name().toLowerCase(Locale.ENGLISH))) continue;
            this.armorTypeMap.put(armorMaterial.name().toLowerCase(Locale.ENGLISH), (ArmorType)armorMaterial);
        }
    }
}

