/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeEquipmentType;
import org.spongepowered.common.data.type.SpongeEquipmentTypeWorn;

public class EquipmentTypeRegistryModule
implements CatalogRegistryModule<EquipmentType> {
    @RegisterCatalog(value=EquipmentTypes.class)
    private final Map<String, EquipmentType> equipmentTypeMap = new HashMap<String, EquipmentType>();

    @Override
    public Optional<EquipmentType> getById(String id) {
        return Optional.ofNullable(this.equipmentTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<EquipmentType> getAll() {
        return ImmutableList.copyOf(this.equipmentTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.equipmentTypeMap.put("any", new SpongeEquipmentType("any"));
        this.equipmentTypeMap.put("equipped", new SpongeEquipmentType("equipped"));
        this.equipmentTypeMap.put("headwear", new SpongeEquipmentTypeWorn("head", 0));
        this.equipmentTypeMap.put("chestplate", new SpongeEquipmentTypeWorn("chestplate", 1));
        this.equipmentTypeMap.put("leggings", new SpongeEquipmentTypeWorn("leggings", 2));
        this.equipmentTypeMap.put("boots", new SpongeEquipmentTypeWorn("boots", 3));
        this.equipmentTypeMap.put("worn", new SpongeEquipmentTypeWorn("worn", 0));
    }
}

