/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemFishFood;
import org.spongepowered.api.data.type.Fish;
import org.spongepowered.api.data.type.Fishes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class FishRegistryModule
implements CatalogRegistryModule<Fish> {
    @RegisterCatalog(value=Fishes.class)
    private final Map<String, Fish> fishMap = new HashMap<String, Fish>();

    @Override
    public Optional<Fish> getById(String id) {
        return Optional.ofNullable(this.fishMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Fish> getAll() {
        return ImmutableList.copyOf(this.fishMap.values());
    }

    @Override
    public void registerDefaults() {
        for (ItemFishFood.FishType fishType : ItemFishFood.FishType.values()) {
            this.fishMap.put(fishType.name().toLowerCase(Locale.ENGLISH), (Fish)fishType);
        }
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (ItemFishFood.FishType fishType : ItemFishFood.FishType.values()) {
            if (this.fishMap.containsValue((Fish)fishType)) continue;
            this.fishMap.put(fishType.name().toLowerCase(Locale.ENGLISH), (Fish)fishType);
        }
    }
}

