/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.scoreboard.Team;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.CollisionRules;

public final class CollisionRuleRegistryModule
implements CatalogRegistryModule<CollisionRule> {
    @RegisterCatalog(value=CollisionRules.class)
    public final Map<String, CollisionRule> collisionRules = Maps.newHashMap();

    @Override
    public void registerDefaults() {
        this.collisionRules.put("always", (CollisionRule)Team.CollisionRule.ALWAYS);
        this.collisionRules.put("never", (CollisionRule)Team.CollisionRule.NEVER);
        this.collisionRules.put("push_other_teams", (CollisionRule)Team.CollisionRule.HIDE_FOR_OWN_TEAM);
        this.collisionRules.put("push_own_team", (CollisionRule)Team.CollisionRule.HIDE_FOR_OTHER_TEAMS);
    }

    @Override
    public Optional<CollisionRule> getById(String id) {
        return Optional.ofNullable(this.collisionRules.get(((String)Preconditions.checkNotNull((Object)id, (Object)"id")).toLowerCase()));
    }

    @Override
    public Collection<CollisionRule> getAll() {
        return ImmutableSet.copyOf(this.collisionRules.values());
    }
}

