/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.common.registry.type.text.TextColorRegistryModule;
import org.spongepowered.common.scoreboard.SpongeDisplaySlot;
import org.spongepowered.common.text.format.SpongeTextColor;

@RegistrationDependency(value={TextColorRegistryModule.class})
public final class DisplaySlotRegistryModule
implements CatalogRegistryModule<DisplaySlot> {
    @RegisterCatalog(value=DisplaySlots.class)
    public final Map<String, SpongeDisplaySlot> displaySlotMappings = Maps.newLinkedHashMap();

    public static DisplaySlotRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    public Optional<DisplaySlot> getForIndex(int id) {
        return Optional.ofNullable(Iterables.get(this.displaySlotMappings.values(), (int)id, null));
    }

    @Override
    public Optional<DisplaySlot> getById(String id) {
        return Optional.ofNullable(this.displaySlotMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<DisplaySlot> getAll() {
        return ImmutableList.copyOf(this.displaySlotMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.displaySlotMappings.put("list", new SpongeDisplaySlot("list", null, 0));
        this.displaySlotMappings.put("sidebar", new SpongeDisplaySlot("sidebar", null, 1));
        this.displaySlotMappings.put("below_name", new SpongeDisplaySlot("below_name", null, 2));
        for (Map.Entry<TextFormatting, SpongeTextColor> entry : TextColorRegistryModule.enumChatColor.entrySet()) {
            this.displaySlotMappings.put(entry.getValue().getId(), new SpongeDisplaySlot(entry.getValue().getId(), entry.getValue(), entry.getKey().func_175746_b() + 3));
        }
    }

    DisplaySlotRegistryModule() {
    }

    private static final class Holder {
        static final DisplaySlotRegistryModule INSTANCE = new DisplaySlotRegistryModule();

        private Holder() {
        }
    }
}

