/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.scoreboard.Team;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.scoreboard.Visibilities;
import org.spongepowered.api.scoreboard.Visibility;

public final class VisibilityRegistryModule
implements CatalogRegistryModule<Visibility> {
    @RegisterCatalog(value=Visibilities.class)
    public static final Map<String, Visibility> visibilityMappings = Maps.newHashMap();

    @Override
    public Optional<Visibility> getById(String id) {
        return Optional.ofNullable(visibilityMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Visibility> getAll() {
        return ImmutableList.copyOf(visibilityMappings.values());
    }

    @Override
    public void registerDefaults() {
        visibilityMappings.put("always", (Visibility)Team.EnumVisible.ALWAYS);
        visibilityMappings.put("never", (Visibility)Team.EnumVisible.NEVER);
        visibilityMappings.put("hide_for_other_teams", (Visibility)Team.EnumVisible.HIDE_FOR_OTHER_TEAMS);
        visibilityMappings.put("hide_for_own_team", (Visibility)Team.EnumVisible.HIDE_FOR_OWN_TEAM);
    }
}

