/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.chat.ChatVisibilities;
import org.spongepowered.api.text.chat.ChatVisibility;
import org.spongepowered.common.interfaces.IMixinEnumChatVisibility;
import org.spongepowered.common.registry.type.text.ChatTypeRegistryModule;

@RegistrationDependency(value={ChatTypeRegistryModule.class})
public final class ChatVisibilityRegistryModule
implements CatalogRegistryModule<ChatVisibility> {
    @RegisterCatalog(value=ChatVisibilities.class)
    public final Map<String, ChatVisibility> chatVisibilityMap = Maps.newHashMap();

    @Override
    public void registerDefaults() {
        this.setChatTypes();
        this.chatVisibilityMap.put("full", (ChatVisibility)EntityPlayer.EnumChatVisibility.FULL);
        this.chatVisibilityMap.put("system", (ChatVisibility)EntityPlayer.EnumChatVisibility.SYSTEM);
        this.chatVisibilityMap.put("hidden", (ChatVisibility)EntityPlayer.EnumChatVisibility.HIDDEN);
    }

    private void setChatTypes() {
        EntityPlayer.EnumChatVisibility FULL = EntityPlayer.EnumChatVisibility.FULL;
        EntityPlayer.EnumChatVisibility SYSTEM = EntityPlayer.EnumChatVisibility.SYSTEM;
        EntityPlayer.EnumChatVisibility HIDDEN = EntityPlayer.EnumChatVisibility.HIDDEN;
        ((IMixinEnumChatVisibility)FULL).setChatTypes((Set<ChatType>)ImmutableSet.copyOf((Collection)ChatTypeRegistryModule.chatTypeMappings.values()));
        ((IMixinEnumChatVisibility)SYSTEM).setChatTypes((Set<ChatType>)ImmutableSet.of((Object)ChatTypes.SYSTEM, (Object)ChatTypes.ACTION_BAR));
        ((IMixinEnumChatVisibility)HIDDEN).setChatTypes((Set<ChatType>)ImmutableSet.of());
    }

    @Override
    public Optional<ChatVisibility> getById(String id) {
        return Optional.ofNullable(this.chatVisibilityMap.get(((String)Preconditions.checkNotNull((Object)id, (Object)"id")).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<ChatVisibility> getAll() {
        return ImmutableSet.copyOf((Object[])((ChatVisibility[])EntityPlayer.EnumChatVisibility.values()));
    }

    @AdditionalRegistration
    public void customRegistration() {
        for (EntityPlayer.EnumChatVisibility visibility : EntityPlayer.EnumChatVisibility.values()) {
            if (this.chatVisibilityMap.containsKey(visibility.name().toLowerCase(Locale.ENGLISH))) continue;
            this.chatVisibilityMap.put(visibility.name().toLowerCase(Locale.ENGLISH), (ChatVisibility)visibility);
        }
    }
}

