/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.text.selector.SelectorType;
import org.spongepowered.api.text.selector.SelectorTypes;
import org.spongepowered.common.text.selector.SpongeSelectorType;

public final class SelectorTypeRegistryModule
implements CatalogRegistryModule<SelectorType> {
    @RegisterCatalog(value=SelectorTypes.class)
    private final Map<String, SelectorType> selectorMappings = Maps.newHashMap();

    @Override
    public Optional<SelectorType> getById(String id) {
        return Optional.ofNullable(this.selectorMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<SelectorType> getAll() {
        return ImmutableList.copyOf(this.selectorMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.selectorMappings.put("all_players", new SpongeSelectorType("a"));
        this.selectorMappings.put("all_entities", new SpongeSelectorType("e"));
        this.selectorMappings.put("nearest_player", new SpongeSelectorType("p"));
        this.selectorMappings.put("random", new SpongeSelectorType("r"));
    }
}

