/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.text;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.text.serializer.TextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.common.text.serializer.JsonTextSerializer;
import org.spongepowered.common.text.serializer.PlainTextSerializer;
import org.spongepowered.common.text.serializer.SpongeFormattingCodeTextSerializer;
import org.spongepowered.common.text.serializer.xml.TextXmlTextSerializer;

public final class TextSerializerRegistryModule
implements AdditionalCatalogRegistryModule<TextSerializer> {
    @RegisterCatalog(value=TextSerializers.class)
    private static final Map<String, TextSerializer> textSerializerMappings = new HashMap<String, TextSerializer>();

    @Override
    public Optional<TextSerializer> getById(String id) {
        return Optional.ofNullable(textSerializerMappings.get(id));
    }

    @Override
    public Collection<TextSerializer> getAll() {
        return ImmutableList.copyOf(textSerializerMappings.values());
    }

    @Override
    public void registerDefaults() {
        textSerializerMappings.put("plain", new PlainTextSerializer());
        textSerializerMappings.put("json", new JsonTextSerializer());
        textSerializerMappings.put("formatting_code", new SpongeFormattingCodeTextSerializer("sponge:formatting_code", "Formatting Codes", '&'));
        textSerializerMappings.put("legacy_formatting_code", new SpongeFormattingCodeTextSerializer("minecraft:legacy_formatting_code", "Legacy Formatting Codes", '\u00a7'));
        textSerializerMappings.put("text_xml", new TextXmlTextSerializer());
    }

    @Override
    public void registerAdditionalCatalog(TextSerializer serializer) {
        textSerializerMappings.put(serializer.getId(), serializer);
    }
}

