/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.WorldType;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.GeneratorTypes;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.world.type.SpongeWorldTypeEnd;
import org.spongepowered.common.world.type.SpongeWorldTypeNether;
import org.spongepowered.common.world.type.SpongeWorldTypeOverworld;

public final class GeneratorTypeRegistryModule
implements CatalogRegistryModule<GeneratorType> {
    @RegisterCatalog(value=GeneratorTypes.class)
    private final Map<String, GeneratorType> generatorTypeMappings = Maps.newHashMap();

    @Override
    public Optional<GeneratorType> getById(String id) {
        return Optional.ofNullable(this.generatorTypeMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<GeneratorType> getAll() {
        return ImmutableList.copyOf(this.generatorTypeMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.generatorTypeMappings.put("amplified", (GeneratorType)WorldType.field_151360_e);
        this.generatorTypeMappings.put("debug", (GeneratorType)WorldType.field_180272_g);
        this.generatorTypeMappings.put("default", (GeneratorType)WorldType.field_77137_b);
        this.generatorTypeMappings.put("the_end", (GeneratorType)((Object)new SpongeWorldTypeEnd()));
        this.generatorTypeMappings.put("flat", (GeneratorType)WorldType.field_77138_c);
        this.generatorTypeMappings.put("large_biomes", (GeneratorType)WorldType.field_77135_d);
        this.generatorTypeMappings.put("nether", (GeneratorType)((Object)new SpongeWorldTypeNether()));
        this.generatorTypeMappings.put("overworld", (GeneratorType)((Object)new SpongeWorldTypeOverworld()));
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (WorldType worldType : WorldType.field_77139_a) {
            if (worldType == null || this.generatorTypeMappings.values().contains(worldType)) continue;
            this.generatorTypeMappings.put(worldType.func_77127_a().toLowerCase(Locale.ENGLISH), (GeneratorType)worldType);
        }
        RegistryHelper.mapFields(GeneratorTypes.class, this.generatorTypeMappings);
    }
}

