/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.Weathers;
import org.spongepowered.common.weather.SpongeWeather;

public final class WeatherRegistryModule
implements CatalogRegistryModule<Weather> {
    @RegisterCatalog(value=Weathers.class)
    private final Map<String, Weather> weatherMappings = Maps.newHashMap();

    @Override
    public Optional<Weather> getById(String id) {
        return Optional.ofNullable(this.weatherMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Weather> getAll() {
        return ImmutableList.copyOf(this.weatherMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.weatherMappings.put("clear", new SpongeWeather("clear"));
        this.weatherMappings.put("rain", new SpongeWeather("rain"));
        this.weatherMappings.put("thunder_storm", new SpongeWeather("thunder_storm"));
    }
}

