/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.extra.modifier.empty.VoidWorldGeneratorModifier;
import org.spongepowered.api.extra.modifier.skylands.SkylandsWorldGeneratorModifier;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.gen.WorldGeneratorModifiers;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public class WorldGeneratorModifierRegistryModule
implements AlternateCatalogRegistryModule<WorldGeneratorModifier>,
SpongeAdditionalCatalogRegistryModule<WorldGeneratorModifier> {
    @RegisterCatalog(value=WorldGeneratorModifiers.class)
    private final Map<String, WorldGeneratorModifier> modifierMappings = new HashMap<String, WorldGeneratorModifier>();

    public static WorldGeneratorModifierRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, WorldGeneratorModifier> provideCatalogMap() {
        HashMap<String, WorldGeneratorModifier> modifierMap = new HashMap<String, WorldGeneratorModifier>();
        for (Map.Entry<String, WorldGeneratorModifier> entry : this.modifierMappings.entrySet()) {
            modifierMap.put(entry.getKey().replace("sponge:", ""), entry.getValue());
        }
        return modifierMap;
    }

    @Override
    public Optional<WorldGeneratorModifier> getById(String id) {
        return Optional.ofNullable(this.modifierMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<WorldGeneratorModifier> getAll() {
        return ImmutableList.copyOf(this.modifierMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.registerAdditionalCatalog(new SkylandsWorldGeneratorModifier());
        this.registerAdditionalCatalog(new VoidWorldGeneratorModifier());
    }

    @Override
    public boolean allowsApiRegistration() {
        return true;
    }

    @Override
    public void registerAdditionalCatalog(WorldGeneratorModifier modifier) {
        Preconditions.checkNotNull((Object)modifier, (Object)"modifier");
        String id = modifier.getId();
        this.checkId(id, "World generator ID");
        this.modifierMappings.put(id.toLowerCase(Locale.ENGLISH), modifier);
    }

    private void checkId(String id, String subject) {
        Preconditions.checkArgument((id.indexOf(32) == -1 ? 1 : 0) != 0, (Object)(subject + " " + id + " may not contain a space"));
    }

    public void checkAllRegistered(Collection<WorldGeneratorModifier> modifiers) {
        this.toIds(modifiers);
    }

    public ImmutableCollection<String> toIds(Collection<WorldGeneratorModifier> modifiers) {
        ImmutableList.Builder ids = ImmutableList.builder();
        for (WorldGeneratorModifier modifier : modifiers) {
            Preconditions.checkNotNull((Object)modifier, (Object)"modifier (in collection)");
            String id = modifier.getId();
            Preconditions.checkArgument((boolean)this.modifierMappings.containsKey(id.toLowerCase(Locale.ENGLISH)), (Object)"unregistered modifier in collection");
            ids.add((Object)id);
        }
        return ids.build();
    }

    public Collection<WorldGeneratorModifier> toModifiers(Collection<String> ids) {
        ArrayList modifiers = Lists.newArrayList();
        for (String id : ids) {
            WorldGeneratorModifier modifier = this.modifierMappings.get(id.toLowerCase(Locale.ENGLISH));
            if (modifier != null) {
                modifiers.add(modifier);
                continue;
            }
            SpongeImpl.getLogger().error("World generator modifier with id " + id + " not found. Missing plugin?");
        }
        return modifiers;
    }

    WorldGeneratorModifierRegistryModule() {
    }

    private static final class Holder {
        static final WorldGeneratorModifierRegistryModule INSTANCE = new WorldGeneratorModifierRegistryModule();

        private Holder() {
        }
    }
}

