/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.type.BiomeTreeType;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;
import org.spongepowered.common.interfaces.world.gen.IWorldGenTrees;
import org.spongepowered.common.world.gen.type.SpongeBiomeTreeType;

public class BiomeTreeTypeRegistryModule
implements CatalogRegistryModule<BiomeTreeType> {
    @RegisterCatalog(value=BiomeTreeTypes.class)
    private final Map<String, BiomeTreeType> biomeTreeTypeMappings = new HashMap<String, BiomeTreeType>();

    @Override
    public Optional<BiomeTreeType> getById(String id) {
        return Optional.ofNullable(this.biomeTreeTypeMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<BiomeTreeType> getAll() {
        return ImmutableList.copyOf(this.biomeTreeTypeMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.biomeTreeTypeMappings.put("oak", new SpongeBiomeTreeType("oak", (PopulatorObject)new WorldGenTrees(false), (PopulatorObject)new WorldGenBigTree(false)));
        this.biomeTreeTypeMappings.put("birch", new SpongeBiomeTreeType("birch", (PopulatorObject)new WorldGenBirchTree(false, false), (PopulatorObject)new WorldGenBirchTree(false, true)));
        WorldGenMegaPineTree tall_megapine = new WorldGenMegaPineTree(false, true);
        WorldGenMegaPineTree megapine = new WorldGenMegaPineTree(false, false);
        this.biomeTreeTypeMappings.put("tall_taiga", new SpongeBiomeTreeType("tall_taiga", (PopulatorObject)new WorldGenTaiga2(false), (PopulatorObject)tall_megapine));
        this.biomeTreeTypeMappings.put("pointy_taiga", new SpongeBiomeTreeType("pointy_taiga", (PopulatorObject)new WorldGenTaiga1(), (PopulatorObject)megapine));
        IBlockState jlog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState jleaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        IBlockState leaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        IWorldGenTrees trees = (IWorldGenTrees)new WorldGenTrees(false, 4, jlog, jleaf, true);
        trees.setMinHeight(VariableAmount.baseWithRandomAddition(4.0, 7.0));
        WorldGenMegaJungle mega = new WorldGenMegaJungle(false, 10, 20, jlog, jleaf);
        this.biomeTreeTypeMappings.put("jungle", new SpongeBiomeTreeType("jungle", (PopulatorObject)((Object)trees), (PopulatorObject)mega));
        WorldGenShrub bush = new WorldGenShrub(jlog, leaf);
        this.biomeTreeTypeMappings.put("jungle_bush", new SpongeBiomeTreeType("jungle_bush", (PopulatorObject)bush, null));
        this.biomeTreeTypeMappings.put("savanna", new SpongeBiomeTreeType("savanna", (PopulatorObject)new WorldGenSavannaTree(false), null));
        this.biomeTreeTypeMappings.put("canopy", new SpongeBiomeTreeType("canopy", (PopulatorObject)new WorldGenCanopyTree(false), null));
        this.biomeTreeTypeMappings.put("swamp", new SpongeBiomeTreeType("swamp", (PopulatorObject)new WorldGenSwamp(), null));
    }
}

