/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.common.registry.RegistryHelper;

public final class BiomeTypeRegistryModule
implements AdditionalCatalogRegistryModule<BiomeType> {
    @RegisterCatalog(value=BiomeTypes.class)
    private final Map<String, BiomeType> biomeTypeMappings = Maps.newHashMap();
    private final List<BiomeType> biomeTypes = new ArrayList<BiomeType>();

    @Override
    public Optional<BiomeType> getById(String id) {
        return Optional.ofNullable(this.biomeTypeMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<BiomeType> getAll() {
        return ImmutableList.copyOf(this.biomeTypes);
    }

    @Override
    public void registerDefaults() {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null) continue;
            this.biomeTypes.add((BiomeType)biome);
        }
        this.biomeTypeMappings.put("ocean", (BiomeType)Biomes.field_76771_b);
        this.biomeTypeMappings.put("plains", (BiomeType)Biomes.field_76772_c);
        this.biomeTypeMappings.put("desert", (BiomeType)Biomes.field_76769_d);
        this.biomeTypeMappings.put("extreme_hills", (BiomeType)Biomes.field_76770_e);
        this.biomeTypeMappings.put("forest", (BiomeType)Biomes.field_76767_f);
        this.biomeTypeMappings.put("taiga", (BiomeType)Biomes.field_76768_g);
        this.biomeTypeMappings.put("swampland", (BiomeType)Biomes.field_76780_h);
        this.biomeTypeMappings.put("river", (BiomeType)Biomes.field_76781_i);
        this.biomeTypeMappings.put("hell", (BiomeType)Biomes.field_76778_j);
        this.biomeTypeMappings.put("sky", (BiomeType)Biomes.field_76779_k);
        this.biomeTypeMappings.put("frozen_ocean", (BiomeType)Biomes.field_76776_l);
        this.biomeTypeMappings.put("frozen_river", (BiomeType)Biomes.field_76777_m);
        this.biomeTypeMappings.put("ice_plains", (BiomeType)Biomes.field_76774_n);
        this.biomeTypeMappings.put("ice_mountains", (BiomeType)Biomes.field_76775_o);
        this.biomeTypeMappings.put("mushroom_island", (BiomeType)Biomes.field_76789_p);
        this.biomeTypeMappings.put("mushroom_island_shore", (BiomeType)Biomes.field_76788_q);
        this.biomeTypeMappings.put("beach", (BiomeType)Biomes.field_76787_r);
        this.biomeTypeMappings.put("desert_hills", (BiomeType)Biomes.field_76786_s);
        this.biomeTypeMappings.put("forest_hills", (BiomeType)Biomes.field_76785_t);
        this.biomeTypeMappings.put("taiga_hills", (BiomeType)Biomes.field_76784_u);
        this.biomeTypeMappings.put("extreme_hills_edge", (BiomeType)Biomes.field_76783_v);
        this.biomeTypeMappings.put("jungle", (BiomeType)Biomes.field_76782_w);
        this.biomeTypeMappings.put("jungle_hills", (BiomeType)Biomes.field_76792_x);
        this.biomeTypeMappings.put("jungle_edge", (BiomeType)Biomes.field_150574_L);
        this.biomeTypeMappings.put("deep_ocean", (BiomeType)Biomes.field_150575_M);
        this.biomeTypeMappings.put("stone_beach", (BiomeType)Biomes.field_150576_N);
        this.biomeTypeMappings.put("cold_beach", (BiomeType)Biomes.field_150577_O);
        this.biomeTypeMappings.put("birch_forest", (BiomeType)Biomes.field_150583_P);
        this.biomeTypeMappings.put("birch_forest_hills", (BiomeType)Biomes.field_150582_Q);
        this.biomeTypeMappings.put("roofed_forest", (BiomeType)Biomes.field_150585_R);
        this.biomeTypeMappings.put("cold_taiga", (BiomeType)Biomes.field_150584_S);
        this.biomeTypeMappings.put("cold_taiga_hills", (BiomeType)Biomes.field_150579_T);
        this.biomeTypeMappings.put("mega_taiga", (BiomeType)Biomes.field_150578_U);
        this.biomeTypeMappings.put("mega_taiga_hills", (BiomeType)Biomes.field_150581_V);
        this.biomeTypeMappings.put("extreme_hills_plus", (BiomeType)Biomes.field_150580_W);
        this.biomeTypeMappings.put("savanna", (BiomeType)Biomes.field_150588_X);
        this.biomeTypeMappings.put("savanna_plateau", (BiomeType)Biomes.field_150587_Y);
        this.biomeTypeMappings.put("mesa", (BiomeType)Biomes.field_150589_Z);
        this.biomeTypeMappings.put("mesa_plateau_forest", (BiomeType)Biomes.field_150607_aa);
        this.biomeTypeMappings.put("mesa_plateau", (BiomeType)Biomes.field_150608_ab);
        this.biomeTypeMappings.put("sunflower_plains", (BiomeType)Biomes.field_185441_Q);
        this.biomeTypeMappings.put("desert_mountains", (BiomeType)Biomes.field_185442_R);
        this.biomeTypeMappings.put("flower_forest", (BiomeType)Biomes.field_185444_T);
        this.biomeTypeMappings.put("taiga_mountains", (BiomeType)Biomes.field_150590_f);
        this.biomeTypeMappings.put("swampland_mountains", (BiomeType)Biomes.field_150599_m);
        this.biomeTypeMappings.put("ice_plains_spikes", (BiomeType)Biomes.field_185445_W);
        this.biomeTypeMappings.put("jungle_mountains", (BiomeType)Biomes.field_185446_X);
        this.biomeTypeMappings.put("jungle_edge_mountains", (BiomeType)Biomes.field_185447_Y);
        this.biomeTypeMappings.put("cold_taiga_mountains", (BiomeType)Biomes.field_185431_ac);
        this.biomeTypeMappings.put("savanna_mountains", (BiomeType)Biomes.field_185435_ag);
        this.biomeTypeMappings.put("savanna_plateau_mountains", (BiomeType)Biomes.field_185436_ah);
        this.biomeTypeMappings.put("mesa_bryce", (BiomeType)Biomes.field_185437_ai);
        this.biomeTypeMappings.put("mesa_plateau_forest_mountains", (BiomeType)Biomes.field_185438_aj);
        this.biomeTypeMappings.put("mesa_plateau_mountains", (BiomeType)Biomes.field_185439_ak);
        this.biomeTypeMappings.put("birch_forest_mountains", (BiomeType)Biomes.field_185448_Z);
        this.biomeTypeMappings.put("birch_forest_hills_mountains", (BiomeType)Biomes.field_185429_aa);
        this.biomeTypeMappings.put("roofed_forest_mountains", (BiomeType)Biomes.field_185430_ab);
        this.biomeTypeMappings.put("mega_spruce_taiga", (BiomeType)Biomes.field_185432_ad);
        this.biomeTypeMappings.put("extreme_hills_mountains", (BiomeType)Biomes.field_185443_S);
        this.biomeTypeMappings.put("extreme_hills_plus_mountains", (BiomeType)Biomes.field_185434_af);
        this.biomeTypeMappings.put("mega_spruce_taiga_hills", (BiomeType)Biomes.field_185433_ae);
        this.biomeTypeMappings.put("void", (BiomeType)Biomes.field_185440_P);
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || this.biomeTypes.contains(biome)) continue;
            this.biomeTypes.add((BiomeType)biome);
            this.biomeTypeMappings.put(biome.func_185359_l().toLowerCase(Locale.ENGLISH), (BiomeType)biome);
        }
        RegistryHelper.mapFields(BiomeTypes.class, this.biomeTypeMappings);
    }

    @Override
    public void registerAdditionalCatalog(BiomeType biome) {
        Preconditions.checkNotNull((Object)biome);
        Preconditions.checkArgument((boolean)(biome instanceof VirtualBiomeType), (Object)"Cannot register non-virtual biomes at this time.");
        Preconditions.checkArgument((!this.getById(biome.getId()).isPresent() ? 1 : 0) != 0, (Object)"Duplicate biome id");
        this.biomeTypes.add(biome);
        this.biomeTypeMappings.put(biome.getId().toLowerCase(Locale.ENGLISH), biome);
    }
}

