/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.PopulatorObjects;
import org.spongepowered.common.interfaces.world.gen.IWorldGenTrees;

public class PopulatorObjectRegistryModule
implements AdditionalCatalogRegistryModule<PopulatorObject> {
    @RegisterCatalog(value=PopulatorObjects.class)
    private final Map<String, PopulatorObject> populatorObjectMappings = new HashMap<String, PopulatorObject>();

    @Override
    public Optional<PopulatorObject> getById(String id) {
        return Optional.ofNullable(this.populatorObjectMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<PopulatorObject> getAll() {
        return ImmutableList.copyOf(this.populatorObjectMappings.values());
    }

    @Override
    public void registerAdditionalCatalog(PopulatorObject extraCatalog) {
        Preconditions.checkNotNull((Object)extraCatalog, (Object)"CatalogType cannot be null");
        Preconditions.checkArgument((!extraCatalog.getId().isEmpty() ? 1 : 0) != 0, (Object)"Id cannot be empty");
        Preconditions.checkArgument((!this.populatorObjectMappings.containsKey(extraCatalog.getId()) ? 1 : 0) != 0, (Object)"Duplicate Id");
        this.populatorObjectMappings.put(extraCatalog.getId(), extraCatalog);
    }

    @Override
    public void registerDefaults() {
        this.populatorObjectMappings.put("desert_well", (PopulatorObject)new WorldGenDesertWells());
        this.populatorObjectMappings.put("oak", (PopulatorObject)new WorldGenTrees(false));
        this.populatorObjectMappings.put("mega_oak", (PopulatorObject)new WorldGenBigTree(false));
        this.populatorObjectMappings.put("birch", (PopulatorObject)new WorldGenBirchTree(false, false));
        this.populatorObjectMappings.put("mega_birch", (PopulatorObject)new WorldGenBirchTree(false, true));
        this.populatorObjectMappings.put("tall_taiga", (PopulatorObject)new WorldGenTaiga2(false));
        this.populatorObjectMappings.put("pointy_taiga", (PopulatorObject)new WorldGenTaiga1());
        this.populatorObjectMappings.put("mega_tall_taiga", (PopulatorObject)new WorldGenMegaPineTree(false, true));
        this.populatorObjectMappings.put("mega_pointy_taiga", (PopulatorObject)new WorldGenMegaPineTree(false, false));
        IBlockState jlog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState jleaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        IBlockState leaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        IWorldGenTrees trees = (IWorldGenTrees)new WorldGenTrees(false, 4, jlog, jleaf, true);
        trees.setId("minecraft:jungle");
        trees.setName("Jungle tree");
        trees.setMinHeight(VariableAmount.baseWithRandomAddition(4.0, 7.0));
        this.populatorObjectMappings.put("jungle", (PopulatorObject)((Object)trees));
        this.populatorObjectMappings.put("mega_jungle", (PopulatorObject)new WorldGenMegaJungle(false, 10, 20, jlog, jleaf));
        WorldGenShrub bush = new WorldGenShrub(jlog, leaf);
        this.populatorObjectMappings.put("jungle_bush", (PopulatorObject)bush);
        this.populatorObjectMappings.put("savanna", (PopulatorObject)new WorldGenSavannaTree(false));
        this.populatorObjectMappings.put("canopy", (PopulatorObject)new WorldGenCanopyTree(false));
        this.populatorObjectMappings.put("swamp", (PopulatorObject)new WorldGenSwamp());
        this.populatorObjectMappings.put("brown", (PopulatorObject)new WorldGenBigMushroom(Blocks.field_150420_aW));
        this.populatorObjectMappings.put("red", (PopulatorObject)new WorldGenBigMushroom(Blocks.field_150419_aX));
    }
}

