/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Functional;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.scheduler.AsyncScheduler;
import org.spongepowered.common.scheduler.ScheduledTask;
import org.spongepowered.common.scheduler.SchedulerBase;
import org.spongepowered.common.scheduler.SpongeTaskBuilder;
import org.spongepowered.common.scheduler.SyncScheduler;
import org.spongepowered.common.scheduler.TaskExecutorService;

public class SpongeScheduler
implements Scheduler {
    private static final SpongeScheduler INSTANCE = new SpongeScheduler();
    public static final int TICK_DURATION_MS = 50;
    public static final long TICK_DURATION_NS = TimeUnit.NANOSECONDS.convert(50L, TimeUnit.MILLISECONDS);
    private final AsyncScheduler asyncScheduler = new AsyncScheduler();
    private final SyncScheduler syncScheduler = new SyncScheduler();

    private SpongeScheduler() {
    }

    public static SpongeScheduler getInstance() {
        return INSTANCE;
    }

    @Override
    public Task.Builder createTaskBuilder() {
        return new SpongeTaskBuilder();
    }

    @Override
    public Optional<Task> getTaskById(UUID id) {
        Optional<Task> optTask = this.syncScheduler.getTask(id);
        if (optTask.isPresent()) {
            return optTask;
        }
        return this.asyncScheduler.getTask(id);
    }

    @Override
    public Set<Task> getTasksByName(String pattern) {
        Pattern searchPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)pattern, (Object)"pattern"));
        Set<Task> matchingTasks = this.getScheduledTasks();
        Iterator<Task> it = matchingTasks.iterator();
        while (it.hasNext()) {
            Matcher matcher = searchPattern.matcher(it.next().getName());
            if (matcher.matches()) continue;
            it.remove();
        }
        return matchingTasks;
    }

    @Override
    public Set<Task> getScheduledTasks() {
        HashSet allTasks = Sets.newHashSet();
        allTasks.addAll(this.asyncScheduler.getScheduledTasks());
        allTasks.addAll(this.syncScheduler.getScheduledTasks());
        return allTasks;
    }

    @Override
    public Set<Task> getScheduledTasks(boolean async) {
        if (async) {
            return this.asyncScheduler.getScheduledTasks();
        }
        return this.syncScheduler.getScheduledTasks();
    }

    @Override
    public Set<Task> getScheduledTasks(Object plugin) {
        String testOwnerId = SpongeScheduler.checkPluginInstance(plugin).getId();
        Set<Task> allTasks = this.getScheduledTasks();
        Iterator<Task> it = allTasks.iterator();
        while (it.hasNext()) {
            String taskOwnerId = it.next().getOwner().getId();
            if (testOwnerId.equals(taskOwnerId)) continue;
            it.remove();
        }
        return allTasks;
    }

    @Override
    public int getPreferredTickInterval() {
        return 50;
    }

    @Override
    public SpongeExecutorService createSyncExecutor(Object plugin) {
        return new TaskExecutorService(() -> this.createTaskBuilder(), this.syncScheduler, SpongeScheduler.checkPluginInstance(plugin));
    }

    @Override
    public SpongeExecutorService createAsyncExecutor(Object plugin) {
        return new TaskExecutorService(() -> this.createTaskBuilder().async(), this.asyncScheduler, SpongeScheduler.checkPluginInstance(plugin));
    }

    static PluginContainer checkPluginInstance(Object plugin) {
        Optional<PluginContainer> optPlugin = SpongeImpl.getGame().getPluginManager().fromInstance(Preconditions.checkNotNull((Object)plugin, (Object)"plugin"));
        Preconditions.checkArgument((boolean)optPlugin.isPresent(), (Object)"Provided object is not a plugin instance");
        return optPlugin.get();
    }

    private SchedulerBase getDelegate(Task task) {
        if (task.isAsynchronous()) {
            return this.asyncScheduler;
        }
        return this.syncScheduler;
    }

    private SchedulerBase getDelegate(ScheduledTask.TaskSynchronicity syncType) {
        if (syncType == ScheduledTask.TaskSynchronicity.ASYNCHRONOUS) {
            return this.asyncScheduler;
        }
        return this.syncScheduler;
    }

    String getNameFor(PluginContainer plugin, ScheduledTask.TaskSynchronicity syncType) {
        return this.getDelegate(syncType).nextName(plugin);
    }

    void submit(ScheduledTask task) {
        this.getDelegate(task).addTask(task);
    }

    public void tickSyncScheduler() {
        this.syncScheduler.tick();
    }

    public <T> CompletableFuture<T> submitAsyncTask(Callable<T> callable) {
        return Functional.asyncFailableFuture(callable, this.asyncScheduler.getExecutor());
    }
}

