/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard.builder;

import com.google.common.base.Preconditions;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.scoreboard.SpongeObjective;

public class SpongeObjectiveBuilder
implements Objective.Builder {
    private String name;
    private Text displayName;
    private Criterion criterion;
    private ObjectiveDisplayMode objectiveDisplayMode;

    public SpongeObjectiveBuilder() {
        this.reset();
    }

    @Override
    public Objective.Builder name(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.name = name;
        return this;
    }

    @Override
    public Objective.Builder displayName(Text displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"DisplayName cannot be null");
        this.displayName = displayName;
        return this;
    }

    @Override
    public Objective.Builder criterion(Criterion criterion) {
        Preconditions.checkNotNull((Object)criterion, (Object)"Criterion cannot be null");
        this.criterion = criterion;
        return this;
    }

    @Override
    public Objective.Builder objectiveDisplayMode(ObjectiveDisplayMode objectiveDisplayMode) {
        Preconditions.checkNotNull((Object)objectiveDisplayMode, (Object)"ObjectiveDisplayMode cannot be null");
        this.objectiveDisplayMode = objectiveDisplayMode;
        return this;
    }

    @Override
    public Objective.Builder from(Objective value) {
        this.name(value.getName()).criterion(value.getCriterion()).displayName(value.getDisplayName()).objectiveDisplayMode(value.getDisplayMode());
        return this;
    }

    @Override
    public SpongeObjectiveBuilder reset() {
        this.name = null;
        this.displayName = null;
        this.criterion = null;
        this.objectiveDisplayMode = ObjectiveDisplayModes.INTEGER;
        return this;
    }

    @Override
    public Objective build() throws IllegalStateException {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Name cannot be null");
        Preconditions.checkState((this.displayName != null ? 1 : 0) != 0, (Object)"DisplayName cannot be null");
        Preconditions.checkState((this.criterion != null ? 1 : 0) != 0, (Object)"Criterion cannot be null");
        SpongeObjective objective = new SpongeObjective(this.name, this.criterion);
        objective.setDisplayName(this.displayName);
        objective.setDisplayMode(this.objectiveDisplayMode);
        return objective;
    }
}

