/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.pagination;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.common.service.pagination.SpongePaginationList;
import org.spongepowered.common.service.pagination.SpongePaginationService;

public class SpongePaginationBuilder
implements PaginationList.Builder {
    private final SpongePaginationService service;
    @Nullable
    private Iterable<Text> contents;
    @Nullable
    private Text title;
    @Nullable
    private Text header;
    @Nullable
    private Text footer;
    private Text paginationSpacer = Text.of("=");
    private int linesPerPage = 20;
    @Nullable
    private PaginationList paginationList;

    public SpongePaginationBuilder(SpongePaginationService service) {
        this.service = service;
    }

    @Override
    public PaginationList.Builder contents(Iterable<Text> contents) {
        this.contents = contents;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder contents(Text ... contents) {
        this.contents = ImmutableList.copyOf((Object[])contents);
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder title(Text title) {
        this.title = title;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder header(@Nullable Text header) {
        this.header = header;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder footer(@Nullable Text footer) {
        this.footer = footer;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder padding(Text padding) {
        Preconditions.checkNotNull((Object)padding, (Object)"padding");
        this.paginationSpacer = padding;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder linesPerPage(int linesPerPage) {
        this.linesPerPage = linesPerPage;
        return this;
    }

    @Override
    public PaginationList build() {
        Preconditions.checkNotNull(this.contents, (Object)"contents");
        if (this.paginationList == null) {
            this.paginationList = new SpongePaginationList(this.service, this.contents, this.title, this.header, this.footer, this.paginationSpacer, this.linesPerPage);
        }
        return this.paginationList;
    }

    @Override
    public void sendTo(MessageReceiver source) {
        this.build().sendTo(source);
    }

    @Override
    public void sendTo(MessageChannel channel) {
        this.build().sendTo(channel);
    }

    @Override
    public PaginationList.Builder from(PaginationList list) {
        this.reset();
        this.contents = list.getContents();
        this.title = list.getTitle().orElse(null);
        this.header = list.getHeader().orElse(null);
        this.footer = list.getFooter().orElse(null);
        this.paginationSpacer = list.getPadding();
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder reset() {
        this.contents = null;
        this.title = null;
        this.header = null;
        this.footer = null;
        this.paginationSpacer = Text.of("=");
        this.paginationList = null;
        return this;
    }
}

