/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.minecraft.server.management.UserListOps;
import org.spongepowered.api.Game;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.service.permission.DataFactoryCollection;
import org.spongepowered.common.service.permission.OpLevelCollection;
import org.spongepowered.common.service.permission.SpongePermissionDescription;
import org.spongepowered.common.service.permission.UserCollection;
import org.spongepowered.common.service.permission.base.FixedParentMemorySubjectData;
import org.spongepowered.common.service.permission.base.GlobalMemorySubjectData;
import org.spongepowered.common.service.permission.base.SpongeSubject;
import org.spongepowered.common.service.permission.base.SpongeSubjectCollection;

public class SpongePermissionService
implements PermissionService {
    private static final String SUBJECTS_DEFAULT = "default";
    private static final Function<String, CommandSource> NO_COMMAND_SOURCE = s -> null;
    private final Game game;
    private final Map<String, PermissionDescription> descriptionMap = new LinkedHashMap<String, PermissionDescription>();
    private Collection<PermissionDescription> descriptions;
    private final ConcurrentMap<String, SubjectCollection> subjects = new ConcurrentHashMap<String, SubjectCollection>();
    private final SpongeSubjectCollection defaultCollection;
    private final SpongeSubject defaultData;

    public SpongePermissionService(Game game) {
        this.game = game;
        this.defaultCollection = this.newCollection(SUBJECTS_DEFAULT);
        this.subjects.put(SUBJECTS_DEFAULT, this.defaultCollection);
        this.subjects.put("user", new UserCollection(this));
        this.subjects.put("group", new OpLevelCollection(this));
        this.subjects.put("commandblock", new DataFactoryCollection("commandblock", this, s -> new FixedParentMemorySubjectData(this, this.getGroupForOpLevel(2)), NO_COMMAND_SOURCE));
        this.subjects.put("system", new DataFactoryCollection("system", this, s -> new FixedParentMemorySubjectData(this, this.getGroupForOpLevel(4)), s -> {
            if (s.equals("Server")) {
                return SpongeImpl.getGame().getServer().getConsole();
            }
            if (s.equals("RCON")) {
                // empty if block
            }
            return null;
        }));
        this.defaultData = this.getDefaultCollection().get(SUBJECTS_DEFAULT);
    }

    static UserListOps getOps() {
        return SpongeImpl.getServer().func_184103_al().func_152603_m();
    }

    static int getServerOpLevel() {
        return SpongeImpl.getServer().func_110455_j();
    }

    public Subject getGroupForOpLevel(int level) {
        return this.getGroupSubjects().get("op_" + level);
    }

    @Override
    public SubjectCollection getUserSubjects() {
        return this.getSubjects("user");
    }

    @Override
    public SubjectCollection getGroupSubjects() {
        return this.getSubjects("group");
    }

    @Override
    public SpongeSubject getDefaults() {
        return this.defaultData;
    }

    @Override
    public void registerContextCalculator(ContextCalculator<Subject> calculator) {
    }

    @Override
    public SubjectCollection getSubjects(String identifier) {
        SubjectCollection existingRet;
        SubjectCollection ret = (SubjectCollection)this.subjects.get(identifier);
        if (ret == null && (existingRet = this.subjects.putIfAbsent(identifier, ret = this.newCollection(identifier))) != null) {
            ret = existingRet;
        }
        return ret;
    }

    private SpongeSubjectCollection newCollection(String identifier) {
        return new DataFactoryCollection(identifier, this, s -> new GlobalMemorySubjectData(this), NO_COMMAND_SOURCE);
    }

    @Override
    public Map<String, SubjectCollection> getKnownSubjects() {
        return ImmutableMap.copyOf(this.subjects);
    }

    @Override
    public Optional<PermissionDescription.Builder> newDescriptionBuilder(Object instance) {
        Optional<PluginContainer> container = this.game.getPluginManager().fromInstance(Preconditions.checkNotNull((Object)instance, (Object)"instance"));
        if (!container.isPresent()) {
            throw new IllegalArgumentException("The provided plugin object does not have an associated plugin container (in other words, is 'plugin' actually your plugin object?)");
        }
        return Optional.of(new SpongePermissionDescription.Builder(this, container.get()));
    }

    public void addDescription(PermissionDescription permissionDescription) {
        Preconditions.checkNotNull((Object)permissionDescription, (Object)"permissionDescription");
        Preconditions.checkNotNull((Object)permissionDescription.getId(), (Object)"permissionId");
        this.descriptionMap.put(permissionDescription.getId().toLowerCase(), permissionDescription);
        this.descriptions = null;
    }

    @Override
    public Optional<PermissionDescription> getDescription(String permissionId) {
        return Optional.ofNullable(this.descriptionMap.get(((String)Preconditions.checkNotNull((Object)permissionId, (Object)"permissionId")).toLowerCase()));
    }

    @Override
    public Collection<PermissionDescription> getDescriptions() {
        ImmutableList descriptions = this.descriptions;
        if (descriptions == null) {
            this.descriptions = descriptions = ImmutableList.copyOf(this.descriptionMap.values());
        }
        return descriptions;
    }

    public SpongeSubjectCollection getDefaultCollection() {
        return this.defaultCollection;
    }
}

