/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.permission.UserSubject;
import org.spongepowered.common.service.permission.base.SpongeSubject;
import org.spongepowered.common.service.permission.base.SpongeSubjectCollection;

public class UserCollection
extends SpongeSubjectCollection {
    public UserCollection(SpongePermissionService service) {
        super("user", service);
    }

    @Override
    public SpongeSubject get(String identifier) {
        UUID uid = this.identToUuid(identifier);
        if (uid == null) {
            throw new IllegalArgumentException("Provided identifier must be a uuid, was " + identifier);
        }
        return this.get(this.uuidToGameProfile(uid));
    }

    protected SpongeSubject get(GameProfile profile) {
        return new UserSubject(profile, this);
    }

    private GameProfile uuidToGameProfile(UUID uniqueId) {
        try {
            return (GameProfile)Sponge.getServer().getGameProfileManager().get(uniqueId, true).get();
        }
        catch (Exception e) {
            SpongeImpl.getLogger().warn("Failed to lookup game profile for {}", new Object[]{uniqueId, e});
            return null;
        }
    }

    @Override
    public boolean hasRegistered(String identifier) {
        UUID uid = this.identToUuid(identifier);
        if (uid == null) {
            return false;
        }
        GameProfile profile = this.uuidToGameProfile(uid);
        return SpongePermissionService.getOps().func_152683_b((Object)profile) != null;
    }

    private UUID identToUuid(String identifier) {
        try {
            return UUID.fromString(identifier);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Iterable<Subject> getAllSubjects() {
        return SpongeImpl.getGame().getServer().getOnlinePlayers();
    }

    public SpongePermissionService getService() {
        return this.service;
    }
}

