/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.UserListOpsEntry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.service.permission.OpLevelCollection;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.permission.UserCollection;
import org.spongepowered.common.service.permission.base.SingleParentMemorySubjectData;
import org.spongepowered.common.service.permission.base.SpongeSubject;

public class UserSubject
extends SpongeSubject {
    private final GameProfile player;
    private final MemorySubjectData data;
    private final UserCollection collection;

    public UserSubject(final GameProfile player, final UserCollection users) {
        this.player = player;
        this.data = new SingleParentMemorySubjectData(users.getService()){

            @Override
            public Subject getParent() {
                int opLevel = UserSubject.this.getOpLevel();
                return opLevel == 0 ? null : users.getService().getGroupForOpLevel(opLevel);
            }

            @Override
            public boolean setParent(Subject parent) {
                int opLevel;
                if (parent == null) {
                    opLevel = 0;
                } else {
                    if (!(parent instanceof OpLevelCollection.OpLevelSubject)) {
                        return false;
                    }
                    opLevel = ((OpLevelCollection.OpLevelSubject)parent).getOpLevel();
                }
                if (opLevel > 0) {
                    SpongePermissionService.getOps().func_152687_a((UserListEntry)new UserListOpsEntry(player, opLevel, false));
                } else {
                    SpongePermissionService.getOps().func_152684_c((Object)player);
                }
                return true;
            }
        };
        this.collection = users;
    }

    @Override
    public String getIdentifier() {
        return this.player.getId().toString();
    }

    @Override
    public Optional<CommandSource> getCommandSource() {
        if (Sponge.isServerAvailable()) {
            return Optional.ofNullable((CommandSource)SpongeImpl.getServer().func_184103_al().func_177451_a(this.player.getId()));
        }
        return Optional.empty();
    }

    int getOpLevel() {
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        UserListOpsEntry entry = (UserListOpsEntry)SpongePermissionService.getOps().func_152683_b((Object)this.player);
        if (entry == null) {
            return SpongeImpl.getServer().func_184103_al().func_152596_g(this.player) ? SpongeImpl.getServer().func_110455_j() : 0;
        }
        return entry.func_152644_a();
    }

    @Override
    public SubjectCollection getContainingCollection() {
        return this.collection;
    }

    @Override
    public MemorySubjectData getSubjectData() {
        return this.data;
    }

    @Override
    public Tristate getPermissionValue(Set<Context> contexts, String permission) {
        Tristate ret = super.getPermissionValue(contexts, permission);
        if (ret == Tristate.UNDEFINED) {
            ret = this.getDataPermissionValue(this.collection.getDefaults().getSubjectData(), permission);
        }
        if (ret == Tristate.UNDEFINED) {
            ret = this.getDataPermissionValue(this.collection.getService().getDefaults().getSubjectData(), permission);
        }
        if (ret == Tristate.UNDEFINED && this.getOpLevel() >= SpongePermissionService.getServerOpLevel()) {
            ret = Tristate.TRUE;
        }
        return ret;
    }

    @Override
    public Optional<String> getOption(Set<Context> contexts, String option) {
        Optional<String> ret = super.getOption(contexts, option);
        if (!ret.isPresent()) {
            ret = this.getDataOptionValue(this.collection.getDefaults().getSubjectData(), option);
        }
        if (!ret.isPresent()) {
            ret = this.getDataOptionValue(this.collection.getService().getDefaults().getSubjectData(), option);
        }
        return ret;
    }
}

