/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission.base;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.common.service.permission.base.GlobalMemorySubjectData;

public class FixedParentMemorySubjectData
extends GlobalMemorySubjectData {
    private final Subject forcedParent;

    public FixedParentMemorySubjectData(PermissionService service, Subject parent) {
        super(service);
        this.forcedParent = parent;
    }

    @Override
    public List<Subject> getParents(Set<Context> contexts) {
        return ImmutableList.builder().add((Object)this.forcedParent).addAll(super.getParents(contexts)).build();
    }

    @Override
    public boolean addParent(Set<Context> contexts, Subject parent) {
        if (Objects.equal((Object)this.forcedParent, (Object)parent) && GLOBAL_CONTEXT.equals(contexts)) {
            return true;
        }
        return super.addParent(contexts, parent);
    }

    @Override
    public boolean removeParent(Set<Context> contexts, Subject parent) {
        if (Objects.equal((Object)this.forcedParent, (Object)parent)) {
            return false;
        }
        return super.removeParent(contexts, parent);
    }
}

