/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission.base;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.common.service.permission.OpLevelCollection;
import org.spongepowered.common.service.permission.base.GlobalMemorySubjectData;

public class SingleParentMemorySubjectData
extends GlobalMemorySubjectData {
    private Subject parent;

    public SingleParentMemorySubjectData(PermissionService service) {
        super(service);
    }

    @Override
    public List<Subject> getParents(Set<Context> contexts) {
        Subject parent = this.getParent();
        return GLOBAL_CONTEXT.equals(contexts) && parent != null ? Collections.singletonList(parent) : Collections.emptyList();
    }

    @Override
    public boolean addParent(Set<Context> contexts, Subject parent) {
        if (!(parent instanceof OpLevelCollection.OpLevelSubject)) {
            return false;
        }
        if (!GLOBAL_CONTEXT.equals(contexts)) {
            return false;
        }
        return this.setParent(parent);
    }

    @Override
    public boolean removeParent(Set<Context> contexts, Subject parent) {
        if (parent == this.parent) {
            return this.setParent(null);
        }
        return false;
    }

    @Override
    public boolean clearParents() {
        return this.removeParent(GLOBAL_CONTEXT, this.parent);
    }

    @Override
    public boolean clearParents(Set<Context> contexts) {
        return GLOBAL_CONTEXT.equals(contexts) && this.clearParents();
    }

    public boolean setParent(Subject parent) {
        this.parent = parent;
        return true;
    }

    public Subject getParent() {
        return this.parent;
    }
}

