/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.Location;

public final class VecHelper {
    public static final Vec3i VEC3_ORIGIN = new Vec3i(0, 0, 0);

    public static BlockPos toBlockPos(Vector3d vector) {
        return new BlockPos(vector.getX(), vector.getY(), vector.getZ());
    }

    public static BlockPos toBlockPos(Vector3i vector) {
        return new BlockPos(vector.getX(), vector.getY(), vector.getZ());
    }

    public static BlockPos toBlockPos(Location<?> location) {
        return VecHelper.toBlockPos(location.getBlockPosition());
    }

    public static Vector3i toVector3i(BlockPos pos) {
        return new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static Vector3d toVector3d(BlockPos pos) {
        return new Vector3d(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static Vector3d toVector3d(Rotations rotation) {
        return new Vector3d(rotation.func_179415_b(), rotation.func_179416_c(), rotation.func_179413_d());
    }

    public static Vector3i toVector3i(Vec3i vector) {
        return new Vector3i(vector.func_177958_n(), vector.func_177956_o(), vector.func_177952_p());
    }

    public static Vec3i toVec3i(Vector3i vector) {
        return new Vec3i(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vec3d toVec3d(Vector3d vector) {
        return new Vec3d(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector3i toVec3i(ChunkPos chunk) {
        return new Vector3i(chunk.field_77276_a, 0, chunk.field_77275_b);
    }

    public static ChunkPos toChunkCoordIntPair(Vector3i vector) {
        return new ChunkPos(vector.getX(), vector.getZ());
    }

    public static Vector3d toVector3d(Vec3d vector) {
        return new Vector3d(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c);
    }

    public static Vec3i toVec3i(Vector3d vector) {
        return new Vec3i(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Rotations toRotation(Vector3d vector) {
        return new Rotations((float)vector.getX(), (float)vector.getY(), (float)vector.getZ());
    }

    public static boolean inBounds(int x, int y, Vector2i min, Vector2i max) {
        return x >= min.getX() && x <= max.getX() && y >= min.getY() && y <= max.getY();
    }

    public static boolean inBounds(int x, int y, int z, Vector3i min, Vector3i max) {
        return x >= min.getX() && x <= max.getX() && y >= min.getY() && y <= max.getY() && z >= min.getZ() && z <= max.getZ();
    }

    public static boolean inBounds(Vector3d pos, Vector3i min, Vector3i max) {
        return VecHelper.inBounds(pos.getX(), pos.getY(), pos.getZ(), min, max);
    }

    public static boolean inBounds(double x, double y, double z, Vector3i min, Vector3i max) {
        return x >= (double)min.getX() && x <= (double)max.getX() && y >= (double)min.getY() && y <= (double)max.getY() && z >= (double)min.getZ() && z <= (double)max.getZ();
    }

    public static AxisAlignedBB toMC(AABB box) {
        return new AxisAlignedBB(box.getMin().getX(), box.getMin().getY(), box.getMin().getZ(), box.getMax().getX(), box.getMax().getY(), box.getMax().getZ());
    }

    public static AABB toSponge(AxisAlignedBB box) {
        return new AABB(new Vector3d(box.field_72340_a, box.field_72338_b, box.field_72339_c), new Vector3d(box.field_72336_d, box.field_72337_e, box.field_72334_f));
    }
}

