/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import java.util.Arrays;
import net.minecraft.block.Block;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.BlockVolumeWorker;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.common.util.gen.AbstractBlockBuffer;
import org.spongepowered.common.util.gen.ByteArrayMutableBlockBuffer;
import org.spongepowered.common.world.extent.ImmutableBlockViewDownsize;
import org.spongepowered.common.world.extent.ImmutableBlockViewTransform;
import org.spongepowered.common.world.extent.worker.SpongeBlockVolumeWorker;
import org.spongepowered.common.world.schematic.GlobalPalette;

public class ByteArrayImmutableBlockBuffer
extends AbstractBlockBuffer
implements ImmutableBlockVolume {
    private static final BlockState AIR = BlockTypes.AIR.getDefaultState();
    private final byte[] blocks;

    private ByteArrayImmutableBlockBuffer(Vector3i start, Vector3i size, byte[] blocks) {
        super(start, size);
        this.blocks = blocks;
    }

    public ByteArrayImmutableBlockBuffer(byte[] blocks, Vector3i start, Vector3i size) {
        super(start, size);
        this.blocks = Arrays.copyOf(blocks, blocks.length);
    }

    @Override
    public BlockPalette getPalette() {
        return GlobalPalette.instance;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        BlockState block = (BlockState)Block.field_176229_d.func_148745_a((int)this.blocks[this.getIndex(x, y, z)]);
        return block == null ? AIR : block;
    }

    @Override
    public ImmutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new ImmutableBlockViewDownsize(this, newMin, newMax);
    }

    @Override
    public ImmutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return new ImmutableBlockViewTransform(this, transform);
    }

    @Override
    public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return this;
    }

    @Override
    public BlockVolumeWorker<? extends ImmutableBlockVolume> getBlockWorker(Cause cause) {
        return new SpongeBlockVolumeWorker<ByteArrayImmutableBlockBuffer>(this, cause);
    }

    @Override
    public MutableBlockVolume getBlockCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ByteArrayMutableBlockBuffer((byte[])this.blocks.clone(), this.start, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    public static ImmutableBlockVolume newWithoutArrayClone(byte[] blocks, Vector3i start, Vector3i size) {
        return new ByteArrayImmutableBlockBuffer(start, size, blocks);
    }
}

